/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.service.impl;

import com.codeupsoft.component.security.properties.SecurityAuthenticateProperties;
import com.codeupsoft.component.security.service.SecurityAuthenticateUserService;
import com.codeupsoft.component.security.service.model.LoginUser;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;

public class SessionSecurityAuthenticateUserService
implements SecurityAuthenticateUserService {
    private static final ThreadLocal<HttpServletRequest> requestHolder = new ThreadLocal();
    private final SecurityAuthenticateProperties securityAuthenticateProperties;

    public static void setCurrentRequest(HttpServletRequest request) {
        requestHolder.set(request);
    }

    public static void clearCurrentRequest() {
        requestHolder.remove();
    }

    @Override
    public LoginUser getLoginUser(HttpServletRequest request) {
        Object attribute = request.getSession().getAttribute(this.securityAuthenticateProperties.getSession().getSessionKey());
        if (Objects.nonNull(attribute)) {
            return (LoginUser)attribute;
        }
        return null;
    }

    @Override
    public void logout(HttpServletRequest request) {
        request.getSession().invalidate();
    }

    @Override
    public String createToken(LoginUser loginUser) {
        HttpServletRequest request = requestHolder.get();
        if (request != null) {
            request.getSession().setAttribute(this.securityAuthenticateProperties.getSession().getSessionKey(), (Object)loginUser);
        }
        return "SESSION";
    }

    @Generated
    public SessionSecurityAuthenticateUserService(SecurityAuthenticateProperties securityAuthenticateProperties) {
        this.securityAuthenticateProperties = securityAuthenticateProperties;
    }
}

