/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.handler;

import com.codeupsoft.component.security.annotation.AnonymousAccess;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class AnonymousAccessHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnonymousAccessHandler.class);
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;
    private final Environment environment;

    public Set<String> getAnonymousAccessPaths() {
        HashSet<String> anonymousPaths = new HashSet<String>();
        String[] activeProfiles = this.environment.getActiveProfiles();
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry entry : handlerMethods.entrySet()) {
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            RequestMappingInfo mappingInfo = (RequestMappingInfo)entry.getKey();
            AnonymousAccess methodAnnotation = (AnonymousAccess)handlerMethod.getMethodAnnotation(AnonymousAccess.class);
            AnonymousAccess classAnnotation = handlerMethod.getBeanType().getAnnotation(AnonymousAccess.class);
            AnonymousAccess annotation = methodAnnotation != null ? methodAnnotation : classAnnotation;
            if (annotation == null || !this.shouldAllowAnonymousAccess(annotation, activeProfiles)) continue;
            Set patterns = mappingInfo.getPatternValues();
            anonymousPaths.addAll(patterns);
            if (!log.isDebugEnabled()) continue;
            log.debug("\u5df2\u6dfb\u52a0\u533f\u540d\u8bbf\u95ee\u8def\u5f84: {} (\u73af\u5883: {})", (Object)patterns, (Object)Arrays.toString(annotation.value()));
        }
        if (log.isInfoEnabled() && !anonymousPaths.isEmpty()) {
            log.info("\u5171\u53d1\u73b0 {} \u4e2a\u533f\u540d\u8bbf\u95ee\u8def\u5f84: {}", (Object)anonymousPaths.size(), anonymousPaths);
        }
        return anonymousPaths;
    }

    private boolean shouldAllowAnonymousAccess(AnonymousAccess annotation, String[] activeProfiles) {
        String[] allowedProfiles = annotation.value();
        if (allowedProfiles == null || allowedProfiles.length == 0) {
            return true;
        }
        if (activeProfiles == null) {
            return false;
        }
        for (String activeProfile : activeProfiles) {
            for (String allowedProfile : allowedProfiles) {
                if (!activeProfile.equals(allowedProfile)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getAnonymousAccessPathArray() {
        Set<String> paths = this.getAnonymousAccessPaths();
        return paths.toArray(new String[0]);
    }

    @Generated
    public AnonymousAccessHandler(RequestMappingHandlerMapping requestMappingHandlerMapping, Environment environment) {
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.environment = environment;
    }
}

