/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.service.impl;

import com.codeupsoft.base.common.utils.DateAppendUtils;
import com.codeupsoft.component.redis.client.RedisTemplateClient;
import com.codeupsoft.component.security.handler.SecurityJwtHandler;
import com.codeupsoft.component.security.properties.SecurityAuthenticateProperties;
import com.codeupsoft.component.security.service.SecurityAuthenticateUserService;
import com.codeupsoft.component.security.service.model.LoginUser;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RedisSecurityAuthenticateUserService
implements SecurityAuthenticateUserService {
    private final RedisTemplateClient redisTemplateClient;
    private final SecurityJwtHandler securityJwtHandler;
    private final SecurityAuthenticateProperties securityAuthenticateProperties;

    @Override
    public LoginUser getLoginUser(HttpServletRequest request) {
        String tokenUid = this.getTokenUid(request);
        if (StringUtils.isNotBlank((CharSequence)tokenUid)) {
            return (LoginUser)this.redisTemplateClient.getCacheObject(this.getRedisKey(tokenUid));
        }
        return null;
    }

    @Override
    public void logout(HttpServletRequest request) {
        String tokenUid = this.getTokenUid(request);
        if (StringUtils.isNotBlank((CharSequence)tokenUid)) {
            this.redisTemplateClient.deleteObject(this.getRedisKey(tokenUid));
        }
    }

    @Override
    public void verifyUser(LoginUser loginUser) {
        long time;
        SecurityAuthenticateProperties.Redis redis = this.securityAuthenticateProperties.getRedis();
        long expireTime = loginUser.getExpireTime();
        if (expireTime <= (time = DateAppendUtils.addMinutes((Date)new Date(), (int)redis.getTokenRefreshScope()).getTime())) {
            expireTime = DateAppendUtils.addMinutes((Date)new Date(), (int)redis.getRedisExpire()).getTime();
            loginUser.setExpireTime(expireTime);
            this.redisTemplateClient.setCacheObject(this.getRedisKey(loginUser.getToken()), (Object)loginUser, (long)redis.getRedisExpire().intValue(), TimeUnit.MINUTES);
        }
    }

    @Override
    public String createToken(LoginUser loginUser) {
        SecurityAuthenticateProperties.Redis redis = this.securityAuthenticateProperties.getRedis();
        String token = this.securityJwtHandler.generateToken(loginUser, redis.getJwtSecret());
        long expireTime = DateAppendUtils.addMinutes((Date)new Date(), (int)redis.getRedisExpire()).getTime();
        loginUser.setExpireTime(expireTime);
        this.redisTemplateClient.setCacheObject(this.getRedisKey(loginUser.getToken()), (Object)loginUser, (long)redis.getRedisExpire().intValue(), TimeUnit.MINUTES);
        return token;
    }

    private String getRedisKey(String tokenUid) {
        SecurityAuthenticateProperties.Redis redis = this.securityAuthenticateProperties.getRedis();
        return redis.getKeyPrefix().concat(tokenUid);
    }

    private String getTokenUid(HttpServletRequest request) {
        SecurityAuthenticateProperties.Redis redis = this.securityAuthenticateProperties.getRedis();
        String token = request.getHeader(redis.getHeader());
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        if (!token.startsWith(redis.getTokenPrefix())) {
            return null;
        }
        if (this.securityJwtHandler.validateToken(token = token.substring(redis.getTokenPrefix().length()), redis.getJwtSecret())) {
            return this.securityJwtHandler.getTokenUid(token);
        }
        return null;
    }

    @Generated
    public RedisSecurityAuthenticateUserService(RedisTemplateClient redisTemplateClient, SecurityJwtHandler securityJwtHandler, SecurityAuthenticateProperties securityAuthenticateProperties) {
        this.redisTemplateClient = redisTemplateClient;
        this.securityJwtHandler = securityJwtHandler;
        this.securityAuthenticateProperties = securityAuthenticateProperties;
    }
}

