/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.component.security.utils;

import com.codeupsoft.component.security.service.model.LoginUser;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public final class SecurityUtils {
    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static LoginUser getLoginUser() {
        Authentication authentication = SecurityUtils.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof LoginUser) {
            LoginUser loginUser = (LoginUser)principal;
            return loginUser;
        }
        return null;
    }

    public static <T extends LoginUser> T getLoginUserExt() {
        Authentication authentication = SecurityUtils.getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof LoginUser) {
            LoginUser loginUser = (LoginUser)principal;
            return (T)loginUser;
        }
        return null;
    }

    public static Long getUserId() {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser == null) {
            return null;
        }
        return loginUser.getUserId();
    }

    public static String getUsername() {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser == null) {
            return null;
        }
        return loginUser.getUsername();
    }

    public static boolean isAuthenticated() {
        Authentication authentication = SecurityUtils.getAuthentication();
        return authentication != null && authentication.isAuthenticated();
    }

    public static boolean hasPermission(String permission) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser == null) {
            return false;
        }
        return loginUser.getPermissions().contains(permission);
    }

    public static boolean hasRole(String role) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if (loginUser == null) {
            return false;
        }
        return loginUser.getRoles().contains(role);
    }

    @Generated
    private SecurityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

