/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.interceptor.ratelimit.autoconfigure;

import com.codeupsoft.interceptor.ratelimit.core.RateLimitInterceptor;
import com.codeupsoft.interceptor.ratelimit.handler.RedisRateLimiterHandler;
import com.codeupsoft.interceptor.ratelimit.properties.RateLimitProperties;
import com.codeupsoft.interceptor.ratelimit.strategy.factory.RateLimitTypeStrategyFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnBean(value={RedisTemplate.class})
@EnableConfigurationProperties(value={RateLimitProperties.class})
@ImportAutoConfiguration(value={RateLimitTypeStrategyFactory.class, RedisRateLimiterHandler.class})
@ConditionalOnProperty(prefix="codeupsoft.interceptor.ratelimit", value={"auto-configure"}, havingValue="true", matchIfMissing=true)
public class RateLimitAutoConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitAutoConfiguration.class);
    private final RateLimitProperties rateLimitProperties;
    private final RateLimitTypeStrategyFactory rateLimitTypeStrategyFactory;
    private final RedisRateLimiterHandler redisRateLimiterHandler;

    public void addInterceptors(InterceptorRegistry registry) {
        log.info("Rate limit auto configuration enabled");
        RateLimitInterceptor interceptor = new RateLimitInterceptor(this.rateLimitProperties, this.rateLimitTypeStrategyFactory, this.redisRateLimiterHandler);
        log.info("Rate limit interceptor added");
        registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(new String[]{"/**"});
    }

    @Generated
    public RateLimitAutoConfiguration(RateLimitProperties rateLimitProperties, RateLimitTypeStrategyFactory rateLimitTypeStrategyFactory, RedisRateLimiterHandler redisRateLimiterHandler) {
        this.rateLimitProperties = rateLimitProperties;
        this.rateLimitTypeStrategyFactory = rateLimitTypeStrategyFactory;
        this.redisRateLimiterHandler = redisRateLimiterHandler;
    }
}

