/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.interceptor.ratelimit.handler;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.data.redis.core.StringRedisTemplate;

@ConditionalOnBean(value={StringRedisTemplate.class})
public class RedisRateLimiterHandler {
    private final StringRedisTemplate redisTemplate;

    public boolean allowRequest(String key, int limit, Long windowTime, TimeUnit timeUnit) {
        Long incremented = this.redisTemplate.opsForValue().increment((Object)key, 1L);
        if (Objects.nonNull(incremented) && Objects.equals(1L, incremented)) {
            this.redisTemplate.expire((Object)key, windowTime.longValue(), timeUnit);
        }
        return Objects.nonNull(incremented) && incremented <= (long)limit;
    }

    @Generated
    public RedisRateLimiterHandler(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

