/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.interceptor.ratelimit.strategy.impl;

import cn.hutool.json.JSONObject;
import com.codeupsoft.base.common.utils.IpUtils;
import com.codeupsoft.interceptor.ratelimit.strategy.RateLimitTypeStrategy;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class DefaultSpElLimitTypeStrategy
implements RateLimitTypeStrategy {
    @Override
    public String getLimitType() {
        return "default";
    }

    @Override
    public String getLimitKey(String key, HandlerMethod handlerMethod, HttpServletRequest request) {
        if (key == null || key.isEmpty()) {
            return "";
        }
        SimpleEvaluationContext context = SimpleEvaluationContext.forReadOnlyDataBinding().build();
        ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(request, Integer.MAX_VALUE);
        context.setVariable("id", (Object)IpUtils.getIpAddr((HttpServletRequest)request));
        if (List.of("POST", "PUT").contains(request.getMethod())) {
            String asString = requestWrapper.getReader().readAllAsString();
            JSONObject jsonObject = new JSONObject((Object)asString);
            for (String s : jsonObject.keySet()) {
                context.setVariable("body." + s, jsonObject.get((Object)s));
            }
        } else {
            for (String s : request.getParameterMap().keySet()) {
                context.setVariable("request." + s, (Object)StringUtils.join((Object[])new String[]{request.getParameter(s), ","}));
            }
        }
        request.getHeaderNames().asIterator().forEachRemaining(headerName -> context.setVariable("header." + headerName, (Object)request.getHeader(headerName)));
        StringBuilder builder = new StringBuilder();
        String[] split = key.split(":");
        SpelExpressionParser parser = new SpelExpressionParser();
        for (String str : split) {
            Expression expression = parser.parseExpression(str);
            builder.append(Optional.ofNullable((String)expression.getValue((EvaluationContext)context, String.class)).orElse(""));
        }
        return builder.toString();
    }
}

