/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.interceptor.ratelimit.autoconfigure;

import com.codeupsoft.interceptor.ratelimit.core.RateLimitInterceptor;
import com.codeupsoft.interceptor.ratelimit.handler.RedisRateLimiterHandler;
import com.codeupsoft.interceptor.ratelimit.properties.RateLimitProperties;
import com.codeupsoft.interceptor.ratelimit.strategy.factory.RateLimitTypeStrategyFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration(after={RateLimitTypeStrategyFactory.class, RedisRateLimiterHandler.class})
@ConditionalOnBean(value={RedisTemplate.class})
@EnableConfigurationProperties(value={RateLimitProperties.class})
@ConditionalOnProperty(prefix="codeupsoft.interceptor.ratelimit", value={"auto-configure"}, havingValue="true", matchIfMissing=true)
public class RateLimitAutoConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitAutoConfiguration.class);
    private final RateLimitProperties rateLimitProperties;
    private final RateLimitTypeStrategyFactory rateLimitTypeStrategyFactory;
    private final StringRedisTemplate redisTemplate;
    private final ApplicationContext applicationContext;

    public void addInterceptors(InterceptorRegistry registry) {
        log.info("Rate limit auto configuration enabled");
        RedisRateLimiterHandler handler = new RedisRateLimiterHandler(this.redisTemplate);
        try {
            handler = (RedisRateLimiterHandler)this.applicationContext.getBean(RedisRateLimiterHandler.class);
        }
        catch (Exception e) {
            log.warn("Could not find RedisRateLimiterHandler bean");
        }
        RateLimitInterceptor interceptor = new RateLimitInterceptor(this.rateLimitProperties, this.rateLimitTypeStrategyFactory, handler);
        log.info("Rate limit interceptor added");
        registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(new String[]{"/**"});
    }

    @Generated
    public RateLimitAutoConfiguration(RateLimitProperties rateLimitProperties, RateLimitTypeStrategyFactory rateLimitTypeStrategyFactory, StringRedisTemplate redisTemplate, ApplicationContext applicationContext) {
        this.rateLimitProperties = rateLimitProperties;
        this.rateLimitTypeStrategyFactory = rateLimitTypeStrategyFactory;
        this.redisTemplate = redisTemplate;
        this.applicationContext = applicationContext;
    }
}

