/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.interceptor.ratelimit.core;

import com.codeupsoft.base.common.exception.CodeupSoftBaseException;
import com.codeupsoft.interceptor.ratelimit.annotation.RateLimit;
import com.codeupsoft.interceptor.ratelimit.annotation.RateLimitIgnore;
import com.codeupsoft.interceptor.ratelimit.handler.RedisRateLimiterHandler;
import com.codeupsoft.interceptor.ratelimit.properties.RateLimitProperties;
import com.codeupsoft.interceptor.ratelimit.strategy.RateLimitTypeStrategy;
import com.codeupsoft.interceptor.ratelimit.strategy.factory.RateLimitTypeStrategyFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class RateLimitInterceptor
implements HandlerInterceptor {
    private final RateLimitProperties rateLimitProperties;
    private final RateLimitTypeStrategyFactory rateLimitTypeStrategyFactory;
    private final RedisRateLimiterHandler redisRateLimiterHandler;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        if (!(handler instanceof HandlerMethod) || (handlerMethod = (HandlerMethod)handler).hasMethodAnnotation(RateLimitIgnore.class)) {
            return true;
        }
        if (handlerMethod.hasMethodAnnotation(RateLimit.class)) {
            RateLimit rateLimit = (RateLimit)handlerMethod.getMethodAnnotation(RateLimit.class);
            String limitType = rateLimit.limitType();
            RateLimitTypeStrategy strategy = this.rateLimitTypeStrategyFactory.getStrategy(limitType);
            String key = rateLimit.prefix() + strategy.getLimitKey(rateLimit.key(), handlerMethod, request);
            boolean allowed = this.redisRateLimiterHandler.allowRequest(key, rateLimit.count(), rateLimit.period(), rateLimit.timeUnit());
            if (!allowed) {
                throw new CodeupSoftBaseException(429, rateLimit.message());
            }
        }
        if (this.rateLimitProperties.isGlobalRateLimitEnabled()) {
            RateLimitTypeStrategy strategy = this.rateLimitTypeStrategyFactory.getStrategy(this.rateLimitProperties.getLimitType());
            String key = this.rateLimitProperties.getPrefix() + strategy.getLimitKey("", handlerMethod, request);
            boolean allowed = this.redisRateLimiterHandler.allowRequest(key, this.rateLimitProperties.getCount(), this.rateLimitProperties.getPeriod(), TimeUnit.SECONDS);
            if (!allowed) {
                throw new CodeupSoftBaseException(429, this.rateLimitProperties.getMessage());
            }
        }
        return true;
    }

    @Generated
    public RateLimitInterceptor(RateLimitProperties rateLimitProperties, RateLimitTypeStrategyFactory rateLimitTypeStrategyFactory, RedisRateLimiterHandler redisRateLimiterHandler) {
        this.rateLimitProperties = rateLimitProperties;
        this.rateLimitTypeStrategyFactory = rateLimitTypeStrategyFactory;
        this.redisRateLimiterHandler = redisRateLimiterHandler;
    }
}

