/*
 * Decompiled with CFR 0.152.
 */
package com.codeupsoft.interceptor.ratelimit.strategy.factory;

import com.codeupsoft.interceptor.ratelimit.strategy.RateLimitTypeStrategy;
import com.codeupsoft.interceptor.ratelimit.strategy.impl.DefaultSpElLimitTypeStrategy;
import com.codeupsoft.interceptor.ratelimit.strategy.impl.IpLimitTypeStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;

@ImportAutoConfiguration(value={IpLimitTypeStrategy.class, DefaultSpElLimitTypeStrategy.class})
public class RateLimitTypeStrategyFactory {
    private final Map<String, RateLimitTypeStrategy> strategies = new HashMap<String, RateLimitTypeStrategy>();

    public RateLimitTypeStrategyFactory(Map<String, RateLimitTypeStrategy> map) {
        map.values().forEach(strategy -> this.strategies.put(strategy.getLimitType(), (RateLimitTypeStrategy)strategy));
    }

    public RateLimitTypeStrategy getStrategy(String strategyName) {
        if (strategyName == null || strategyName.trim().isEmpty()) {
            return this.strategies.get("default");
        }
        RateLimitTypeStrategy strategy = this.strategies.get(strategyName);
        if (Objects.isNull(strategy)) {
            throw new IllegalArgumentException("\u672a\u77e5\u9650\u6d41\u7b56\u7565: " + strategyName);
        }
        return strategy;
    }
}

