package com.codeupsoft.interceptor.xss.properties;

import java.util.ArrayList;
import java.util.List;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * XSS防护配置属性类.
 *
 * <p>用于读取和存储XSS防护相关的配置属性.
 *
 * @author codeupsoft
 */
@Data
@ConfigurationProperties(prefix = "codeupsoft.interceptor.xss")
public class XssProperties {

  /** 是否开启XSS防护. */
  private boolean enabled = true;

  /** 是否开启自动配置. */
  private boolean autoConfigure = true;

  /** 忽略XSS防护的URL白名单. */
  private List<String> ignoreUrls = new ArrayList<>();

  /** 忽略XSS防护的请求方法. */
  private List<String> ignoreMethods = new ArrayList<>();
}
