package com.codeyaa.utils;

import com.codeyaa.exception.AesException;
import com.codeyaa.model.VxCheckRequest;
import com.codeyaa.model.VxMsgModel;
import com.codeyaa.utils.wechat.WXBizMsgCrypt;
import com.google.gson.Gson;
import net.dongliu.requests.Requests;
import net.dongliu.requests.Session;

import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * @Classname WXUtil
 * @Description TODO
 * @Date 2021/5/24 18:37
 * @Created by DELL
 */
public class WeChatUtil {
    /**
     * 公众号 -> 开发 -> 基本配置
     * 开发者ID(AppID)
     * 开发者密码(AppSecret)
     */
    private String appId;
    private String secret;
    /**
     * 公众号 -> 开发 -> 服务器配置
     * 消息加解密采用安全模式
     * 令牌(Token)
     * 消息加解密密钥(EncodingAESKey)
     */
    private String saveToken;
    private String encodingAesKey;
    /**
     * qq 交流群
     */
    private String qqFlock;
    /**
     * 微信加解密工具类
     */
    WXBizMsgCrypt pc;

    private Gson gson = new Gson();

    public String getToken() {
        String url = "https://api.weixin.qq.com/cgi-bin/token";
        String apiUrl = url + "?grant_type=" + "client_credential&appid=" + appId + "&secret=" + secret;
        Session session = Requests.session();
        String respText = session.post(apiUrl)
                .send()
                .charset(StandardCharsets.UTF_8)
                .readToText();
        Map map = gson.fromJson(respText, Map.class);
        String token = (String) map.get("access_token");
        return token;

    }

    public String getUserNickName(String token, String openid) {
        String apiUrlGZH = String.format("https://api.weixin.qq.com/cgi-bin/user/info?access_token=%s&openid=%s&lang=zh_CN", token, openid);
        String resGZH = Requests.session().get(apiUrlGZH)
                .charset(StandardCharsets.UTF_8)
                .send()
                .readToText();
        Map map = gson.fromJson(resGZH, Map.class);
        String nickname = (String) map.get("nickname");
        return nickname;
    }

    public String sendXmlBody(VxMsgModel vxMsgModel, String content, VxCheckRequest vxCheckRequest, boolean encode) {
        StringBuilder builder = new StringBuilder();
        String res = "";
        content += String.format("\n交流群：%s（QQ）", qqFlock);
        builder.append("<xml>\n")
                .append("<ToUserName>").append("<![CDATA[" + vxMsgModel.getFromUsername() + "]]>").append("</ToUserName>\n")
                .append("<FromUserName>").append("<![CDATA[" + vxMsgModel.getToUsername() + "]]>").append("</FromUserName>\n")
                .append("<CreateTime>").append(System.currentTimeMillis()).append("</CreateTime>\n")
                .append("<MsgType>").append("<![CDATA[text]]>").append("</MsgType>\n")
                .append("<Content>").append("<![CDATA[" + content + "]]>").append("</Content>\n")
                .append("</xml>");

        try {
            if (encode) {
                res = pc.encryptMsg(builder.toString(), vxCheckRequest.getTimestamp(), vxCheckRequest.getNonce());
            } else {
                res = builder.toString();
            }
        } catch (AesException e) {
            e.printStackTrace();
        }
        return res;
    }
    public String sendVoiceXmlBody(VxMsgModel vxMsgModel, WXBizMsgCrypt pc, VxCheckRequest vxCheckRequest, boolean encode) {
        StringBuilder builder = new StringBuilder();
        String res = "";
        builder.append("<xml>\n")
                .append("<ToUserName>").append("<![CDATA[" + vxMsgModel.getFromUsername() + "]]>").append("</ToUserName>\n")
                .append("<FromUserName>").append("<![CDATA[" + vxMsgModel.getToUsername() + "]]>").append("</FromUserName>\n")
                .append("<CreateTime>").append(System.currentTimeMillis()).append("</CreateTime>\n")
                .append("<MsgType>").append("<![CDATA[voice]]>").append("</MsgType>\n")
                .append("<Voice>")
                .append("<MediaId>").append("<![CDATA[" + vxMsgModel.getMediaId() + "]]>").append("</MediaId>\n")
                .append("</Voice>")
                .append("</xml>");

        try {
            if (encode) {
                res = pc.encryptMsg(builder.toString(), vxCheckRequest.getTimestamp(), vxCheckRequest.getNonce());
            } else {
                res = builder.toString();
            }
        } catch (AesException e) {
            e.printStackTrace();
        }
        return res;
    }
    private String sendArticleXmlBody(VxMsgModel vxMsgModel, String content, WXBizMsgCrypt pc, VxCheckRequest vxCheckRequest, boolean encode) {
        StringBuilder builder = new StringBuilder();
        String res = "";
        content += String.format("\n交流群：%s（QQ）", qqFlock);
        builder.append("<xml>\n")
                .append("<ToUserName>").append("<![CDATA[" + vxMsgModel.getFromUsername() + "]]>").append("</ToUserName>\n")
                .append("<FromUserName>").append("<![CDATA[" + vxMsgModel.getToUsername() + "]]>").append("</FromUserName>\n")
                .append("<CreateTime>").append(System.currentTimeMillis()).append("</CreateTime>\n")
                .append("<MsgType>").append("<![CDATA[news]]>").append("</MsgType>\n")
                .append("<ArticleCount>").append("1").append("</ArticleCount>\n")
                .append("<Articles>")
                .append("<item>")
                .append("<Title>").append("<![CDATA[" + "" + "]]>").append("</Title>\n")
                .append("<Description>").append("<![CDATA[" + content + "]]>").append("</Description>\n")
                .append("<PicUrl>").append("<![CDATA[" + vxMsgModel.getMediaUrl() + "]]>").append("</PicUrl>\n")
                .append("<Url>").append("<![CDATA[" + "#" + "]]>").append("</Url>\n")
                .append("</Articles>")
                .append("</item>")
                .append("</xml>");

        try {
            if (encode) {
                res = pc.encryptMsg(builder.toString(), vxCheckRequest.getTimestamp(), vxCheckRequest.getNonce());
            } else {
                res = builder.toString();
            }
        } catch (AesException e) {
            e.printStackTrace();
        }
        return res;
    }
    private String sendImgXmlBody(VxMsgModel vxMsgModel, WXBizMsgCrypt pc, VxCheckRequest vxCheckRequest, boolean encode) {
        StringBuilder builder = new StringBuilder();
        String res = "";
        builder.append("<xml>\n")
                .append("<ToUserName>").append("<![CDATA[" + vxMsgModel.getFromUsername() + "]]>").append("</ToUserName>\n")
                .append("<FromUserName>").append("<![CDATA[" + vxMsgModel.getToUsername() + "]]>").append("</FromUserName>\n")
                .append("<CreateTime>").append(System.currentTimeMillis()).append("</CreateTime>\n")
                .append("<MsgType>").append("<![CDATA[image]]>").append("</MsgType>\n")
                .append("<Image>")
                .append("<MediaId>").append(String.format("<![CDATA[%s]]>", vxMsgModel.getMediaId())).append("</MediaId>\n")
                .append("</Image>")
                .append("</xml>");

        try {
            if (encode) {
                res = pc.encryptMsg(builder.toString(), vxCheckRequest.getTimestamp(), vxCheckRequest.getNonce());
            } else {
                res = builder.toString();
            }
        } catch (AesException e) {
            e.printStackTrace();
        }
        return res;
    }
}
