package com.codeyaa.utils.wechat;


import com.codeyaa.exception.AesException;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * @Classname SHA1Util
 * @Description TODO
 * @Date 2021/5/20 05:16
 * @Created by DELL
 */
public class SHA1Util {



    /**
     * sha1加密操作
     */

    public static String encrypt(String content) {
        try {
            // Create MD5 Hash

            MessageDigest digest = MessageDigest.getInstance("SHA-1");

            digest.update(content.getBytes());

            byte messageDigest[] = digest.digest();

            // Create Hex String

            StringBuffer hexString = new StringBuffer();

            for (int i = 0; i < messageDigest.length; i++)

                hexString.append(String.format("%02X", 0xFF & messageDigest[i]));

            return hexString.toString().toLowerCase();

        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();

        }

        return "";

    }

    /**
     * 用SHA1算法生成安全签名
     *
     * @param token     票据
     * @param timestamp 时间戳
     * @param nonce     随机字符串
     * @param encrypt   密文
     * @return 安全签名
     * @throws AesException
     */
    public static String getSHA1(String token, String timestamp, String nonce, String encrypt) throws AesException {
        try {
            String[] array = new String[]{token, timestamp, nonce, encrypt};
            StringBuffer sb = new StringBuffer();
            // 字符串排序
            Arrays.sort(array);
            for (int i = 0; i < 4; i++) {
                sb.append(array[i]);
            }
            String str = sb.toString();
            // SHA1签名生成
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes());
            byte[] digest = md.digest();

            StringBuffer hexstr = new StringBuffer();
            String shaHex = "";
            for (int i = 0; i < digest.length; i++) {
                shaHex = Integer.toHexString(digest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexstr.append(0);
                }
                hexstr.append(shaHex);
            }
            return hexstr.toString();
        } catch (Exception e) {
            e.printStackTrace();
            throw new AesException(AesException.ComputeSignatureError);
        }
    }





}
