/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.handler;

import com.codingapi.springboot.framework.event.IEvent;
import com.codingapi.springboot.framework.handler.IHandler;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHandlerUtils
implements IHandler<IEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationHandlerUtils.class);
    private static ApplicationHandlerUtils instance;
    private List<IHandler<IEvent>> handleres = new ArrayList<IHandler<IEvent>>();

    private ApplicationHandlerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationHandlerUtils getInstance() {
        if (instance != null) return instance;
        Class<ApplicationHandlerUtils> clazz = ApplicationHandlerUtils.class;
        synchronized (ApplicationHandlerUtils.class) {
            if (instance != null) return instance;
            instance = new ApplicationHandlerUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addHandlers(List<IHandler<IEvent>> handleres) {
        if (handleres != null) {
            handleres.addAll(handleres);
        }
    }

    public void addHandler(IHandler<IEvent> handler) {
        if (handler != null) {
            this.handleres.add(handler);
        }
    }

    @Override
    public void handler(IEvent event) {
        for (IHandler<IEvent> handler : this.handleres) {
            try {
                handler.handler(event);
            }
            catch (Exception e) {
                log.error("handler exception", (Throwable)e);
            }
        }
    }
}

