/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.executor;

import com.codingapi.springboot.fast.executor.JpaQuery;
import com.codingapi.springboot.framework.dto.response.MultiResponse;
import com.codingapi.springboot.framework.dto.response.SingleResponse;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;

public class JpaExecutor {
    private final EntityManager entityManager;

    public Object execute(String hql, String countHql, Object[] args, Class<?> returnType) {
        JpaQuery query = new JpaQuery(hql, countHql, args, this.entityManager);
        if (returnType.equals(SingleResponse.class)) {
            List list = (List)query.getResultList();
            return list == null && list.size() > 0 ? SingleResponse.of(list.get(0)) : SingleResponse.empty();
        }
        if (returnType.equals(MultiResponse.class)) {
            Object returnData = query.getResultList();
            if (Page.class.isAssignableFrom(returnData.getClass())) {
                return MultiResponse.of((Page)((Page)returnData));
            }
            if (Collection.class.isAssignableFrom(returnData.getClass())) {
                return MultiResponse.of((Collection)((Collection)returnData));
            }
        }
        return query.getResultList();
    }

    public JpaExecutor(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

