/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.executor;

import java.lang.reflect.Field;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JpaQuery {
    private static final Logger log = LoggerFactory.getLogger(JpaQuery.class);
    private final Object[] args;
    private final Query query;
    private final String hql;
    private final String countHql;
    private final EntityManager entityManager;

    public JpaQuery(String hql, String countHql, Object[] args, EntityManager entityManager) {
        this.hql = hql;
        this.countHql = countHql;
        this.args = args;
        this.entityManager = entityManager;
        this.query = entityManager.createQuery(hql);
        this.initParameter(this.query);
    }

    private void initParameter(Query query) {
        if (this.args != null && this.args.length > 0) {
            Set parameters = query.getParameters();
            for (Parameter parameter : parameters) {
                Integer position = parameter.getPosition();
                if (position != null) {
                    query.setParameter(position.intValue(), this.args[position - 1]);
                }
                if (!StringUtils.hasText((String)parameter.getName())) continue;
                String name = parameter.getName();
                Object obj = this.args[0];
                Field field = ReflectionUtils.findField(obj.getClass(), (String)name);
                if (field == null) continue;
                field.setAccessible(true);
                query.setParameter(name, field.get(obj));
            }
        }
    }

    private boolean isPageable() {
        if (this.args != null && this.args.length > 0 && StringUtils.hasText((String)this.countHql)) {
            Object lastObj = this.args[this.args.length - 1];
            return lastObj instanceof Pageable;
        }
        return false;
    }

    private Pageable getPageable() {
        if (this.isPageable()) {
            Object lastObj = this.args[this.args.length - 1];
            return (Pageable)lastObj;
        }
        return null;
    }

    public Object getResultList() {
        if (this.isPageable()) {
            Pageable pageable = this.getPageable();
            this.query.setFirstResult((int)pageable.getOffset());
            this.query.setMaxResults(pageable.getPageSize());
            long total = this.getCount();
            return new PageImpl(this.query.getResultList(), pageable, total);
        }
        return this.query.getResultList();
    }

    private long getCount() {
        Query countQuery = this.entityManager.createQuery(this.countHql);
        this.initParameter(countQuery);
        return (Long)countQuery.getSingleResult();
    }

    public Object getSingleResult() {
        return this.query.getSingleResult();
    }
}

