/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.registrar;

import com.codingapi.springboot.fast.annotation.FastMapping;
import com.codingapi.springboot.fast.exception.FastMappingErrorException;
import com.codingapi.springboot.fast.executor.JpaExecutor;
import com.codingapi.springboot.fast.executor.MvcMethodProxy;
import com.codingapi.springboot.fast.mapping.MvcEndpointMapping;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

public class MvcMappingRegistrar {
    private static final Logger log = LoggerFactory.getLogger(MvcMappingRegistrar.class);
    protected static final Set<Class<?>> classSet = new HashSet();
    private final MvcEndpointMapping mvcEndpointMapping;
    private final JpaExecutor jpaExecutor;

    public void registerMvcMapping() {
        for (Class<?> clazz : classSet) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                FastMapping fastMapping = method.getAnnotation(FastMapping.class);
                if (!this.verify(fastMapping, method)) continue;
                MvcMethodProxy handler = new MvcMethodProxy(this.jpaExecutor);
                Object methodProxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)handler);
                this.mvcEndpointMapping.addMapping(fastMapping.mapping(), fastMapping.method(), methodProxy, method);
            }
        }
    }

    private boolean verify(FastMapping fastMapping, Method method) throws FastMappingErrorException {
        Class<?>[] parameterTypes;
        if (fastMapping == null) {
            return false;
        }
        if (!StringUtils.hasText((String)fastMapping.mapping())) {
            throw new FastMappingErrorException(String.format("fast method %s missing mapping .", method.getName()));
        }
        if (!StringUtils.hasText((String)fastMapping.value())) {
            throw new FastMappingErrorException(String.format("fast mapping %s missing value .", fastMapping.mapping()));
        }
        for (Class<?> parameter : parameterTypes = method.getParameterTypes()) {
            if (!Pageable.class.isAssignableFrom(parameter) || StringUtils.hasText((String)fastMapping.countQuery())) continue;
            throw new FastMappingErrorException(String.format("fast mapping %s missing countQuery .", fastMapping.mapping()));
        }
        return true;
    }

    public MvcMappingRegistrar(MvcEndpointMapping mvcEndpointMapping, JpaExecutor jpaExecutor) {
        this.mvcEndpointMapping = mvcEndpointMapping;
        this.jpaExecutor = jpaExecutor;
    }
}

