/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.registrar;

import com.codingapi.springboot.fast.annotation.FastMapping;
import com.codingapi.springboot.fast.exception.FastMappingErrorException;
import com.codingapi.springboot.fast.executor.JpaExecutor;
import com.codingapi.springboot.fast.executor.MvcMethodInterceptor;
import com.codingapi.springboot.fast.mapping.MvcEndpointMapping;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyFactory;
import org.springframework.aop.framework.DefaultAopProxyFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

public class MvcMappingRegistrar {
    private static final Logger log = LoggerFactory.getLogger(MvcMappingRegistrar.class);
    protected static final Set<Class<?>> classSet = new HashSet();
    private final MvcEndpointMapping mvcEndpointMapping;
    private final AopProxyFactory proxyFactory;
    private final List<Advisor> advisors;
    private final MvcMethodInterceptor interceptor;

    public MvcMappingRegistrar(MvcEndpointMapping mvcEndpointMapping, JpaExecutor jpaExecutor, List<Advisor> advisors) {
        this.mvcEndpointMapping = mvcEndpointMapping;
        this.advisors = advisors;
        this.interceptor = new MvcMethodInterceptor(jpaExecutor);
        this.proxyFactory = new DefaultAopProxyFactory();
    }

    public void registerMvcMapping() {
        for (Class<?> clazz : classSet) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                FastMapping fastMapping = method.getAnnotation(FastMapping.class);
                if (!this.verify(fastMapping, method)) continue;
                AdvisedSupport advisedSupport = this.createAdvisedSupport(clazz);
                AopProxy proxy = this.proxyFactory.createAopProxy(advisedSupport);
                this.mvcEndpointMapping.addMapping(fastMapping.mapping(), fastMapping.method(), proxy.getProxy(), method);
            }
        }
    }

    private AdvisedSupport createAdvisedSupport(Class<?> clazz) {
        AdvisedSupport advisedSupport = new AdvisedSupport(new Class[]{clazz});
        advisedSupport.setTarget((Object)this.interceptor);
        advisedSupport.addAdvisors(this.advisors);
        advisedSupport.addAdvice((Advice)this.interceptor);
        return advisedSupport;
    }

    private boolean verify(FastMapping fastMapping, Method method) throws FastMappingErrorException {
        Class<?>[] parameterTypes;
        if (fastMapping == null) {
            return false;
        }
        if (!StringUtils.hasText((String)fastMapping.mapping())) {
            throw new FastMappingErrorException(String.format("fast method %s missing mapping .", method.getName()));
        }
        if (!StringUtils.hasText((String)fastMapping.value())) {
            throw new FastMappingErrorException(String.format("fast mapping %s missing value .", fastMapping.mapping()));
        }
        for (Class<?> parameter : parameterTypes = method.getParameterTypes()) {
            if (!Pageable.class.isAssignableFrom(parameter) || StringUtils.hasText((String)fastMapping.countQuery())) continue;
            throw new FastMappingErrorException(String.format("fast mapping %s missing countQuery .", fastMapping.mapping()));
        }
        return true;
    }
}

