/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.executor;

import com.codingapi.springboot.fast.annotation.FastMapping;
import com.codingapi.springboot.fast.executor.JpaExecutor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MvcMethodInterceptor
implements MethodInterceptor {
    private final JpaExecutor jpaExecutor;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        if (method.equals(Object.class.getMethod("equals", Object.class))) {
            return false;
        }
        if (method.equals(Object.class.getMethod("hashCode", new Class[0]))) {
            return this.hashCode();
        }
        FastMapping fastMapping = method.getAnnotation(FastMapping.class);
        if (fastMapping != null) {
            Class<?> returnType = method.getReturnType();
            return this.jpaExecutor.execute(fastMapping.value(), fastMapping.countQuery(), args, returnType);
        }
        return null;
    }

    public MvcMethodInterceptor(JpaExecutor jpaExecutor) {
        this.jpaExecutor = jpaExecutor;
    }
}

