/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.jpa;

import java.util.ArrayList;
import java.util.List;

public class SQLBuilder {
    private final StringBuilder sqlBuilder;
    private final StringBuilder countSQLBuilder;
    private int index;
    private final List<Object> params;
    private final Class<?> clazz;

    public SQLBuilder(String sql) {
        this(null, sql, "select count(1) from " + sql);
    }

    public SQLBuilder(Class<?> clazz, String sql) {
        this(clazz, sql, "select count(1) from " + sql);
    }

    public SQLBuilder(String sql, String countSql) {
        this(null, sql, countSql);
    }

    public SQLBuilder(Class<?> clazz, String sql, String countSQL) {
        this.countSQLBuilder = new StringBuilder(countSQL);
        this.sqlBuilder = new StringBuilder(sql);
        this.index = 1;
        this.params = new ArrayList<Object>();
        this.clazz = clazz;
    }

    public void append(String sql, Object value) {
        if (value != null) {
            this.sqlBuilder.append(" ").append(sql).append(this.index).append(" ");
            this.countSQLBuilder.append(" ").append(sql).append(this.index).append(" ");
            this.params.add(value);
            ++this.index;
        }
    }

    public void addParam(Object value) {
        this.params.add(value);
        ++this.index;
    }

    public void addParam(Object value, int index) {
        this.params.add(value);
        this.index = index;
    }

    public void appendSql(String sql) {
        this.sqlBuilder.append(" ").append(sql).append(" ");
        this.countSQLBuilder.append(" ").append(sql).append(" ");
    }

    public String getSQL() {
        return this.sqlBuilder.toString();
    }

    public String getCountSQL() {
        return this.countSQLBuilder.toString();
    }

    public Object[] getParams() {
        return this.params.toArray();
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }
}

