/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.jpa.repository;

import com.codingapi.springboot.framework.dto.request.Filter;
import com.codingapi.springboot.framework.dto.request.PageRequest;
import com.codingapi.springboot.framework.dto.request.RequestFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;

class DynamicSQLBuilder {
    private static final Logger log = LoggerFactory.getLogger(DynamicSQLBuilder.class);
    private final PageRequest request;
    private final Class<?> clazz;
    private final List<Object> params = new ArrayList<Object>();
    private int paramIndex = 1;

    public DynamicSQLBuilder(PageRequest request, Class<?> clazz) {
        this.request = request;
        this.clazz = clazz;
    }

    public String getHQL() {
        Sort sort;
        StringBuilder hql = new StringBuilder("FROM " + this.clazz.getSimpleName() + " WHERE ");
        RequestFilter requestFilter = this.request.getRequestFilter();
        if (requestFilter.hasFilter()) {
            List filters = requestFilter.getFilters();
            for (int i = 0; i < filters.size(); ++i) {
                Filter filter = (Filter)filters.get(i);
                this.buildSQL(filter, hql);
                if (i == filters.size() - 1) continue;
                hql.append(" AND ");
            }
        }
        if ((sort = this.request.getSort()).isSorted()) {
            hql.append(" ORDER BY ");
            List orders = sort.toList();
            for (int i = 0; i < orders.size(); ++i) {
                Sort.Order order = (Sort.Order)orders.get(i);
                hql.append(order.getProperty()).append(" ").append(order.getDirection().name());
                if (i == orders.size() - 1) continue;
                hql.append(",");
            }
        }
        log.debug("hql:{}", (Object)hql);
        log.debug("params:{}", this.params);
        return hql.toString();
    }

    private void buildSQL(Filter filter, StringBuilder hql) {
        Filter[] andFilters;
        int i;
        Filter[] orFilters;
        if (filter.isOrFilters() && (orFilters = (Filter[])filter.getValue()).length > 0) {
            hql.append(" ( ");
            for (i = 0; i < orFilters.length; ++i) {
                Filter orFilter = orFilters[i];
                this.buildSQL(orFilter, hql);
                if (i == orFilters.length - 1) continue;
                hql.append(" OR ");
            }
            hql.append(" )");
        }
        if (filter.isAndFilters() && (andFilters = (Filter[])filter.getValue()).length > 0) {
            hql.append(" ( ");
            for (i = 0; i < andFilters.length; ++i) {
                Filter andFilter = andFilters[i];
                this.buildSQL(andFilter, hql);
                if (i == andFilters.length - 1) continue;
                hql.append(" AND ");
            }
            hql.append(" )");
        }
        if (filter.isEqual()) {
            hql.append(filter.getKey()).append(" = ?").append(this.paramIndex);
            this.params.add(filter.getValue()[0]);
            ++this.paramIndex;
        }
        if (filter.isNull()) {
            hql.append(filter.getKey()).append(" IS NULL ");
        }
        if (filter.isNotNull()) {
            hql.append(filter.getKey()).append(" IS NOT NULL ");
        }
        if (filter.isNotEqual()) {
            hql.append(filter.getKey()).append(" != ?").append(this.paramIndex);
            this.params.add(filter.getValue()[0]);
            ++this.paramIndex;
        }
        if (filter.isLike()) {
            hql.append(filter.getKey()).append(" LIKE ?").append(this.paramIndex);
            this.params.add("%" + filter.getValue()[0] + "%");
            ++this.paramIndex;
        }
        if (filter.isLeftLike()) {
            hql.append(filter.getKey()).append(" LIKE ?").append(this.paramIndex);
            this.params.add("%" + filter.getValue()[0]);
            ++this.paramIndex;
        }
        if (filter.isRightLike()) {
            hql.append(filter.getKey()).append(" LIKE ?").append(this.paramIndex);
            this.params.add(filter.getValue()[0] + "%");
            ++this.paramIndex;
        }
        if (filter.isIn()) {
            hql.append(filter.getKey()).append(" IN (").append("?").append(this.paramIndex).append(")");
            this.params.add(Arrays.asList(filter.getValue()));
            ++this.paramIndex;
        }
        if (filter.isNotIn()) {
            hql.append(filter.getKey()).append(" NOT IN (").append("?").append(this.paramIndex).append(")");
            this.params.add(Arrays.asList(filter.getValue()));
            ++this.paramIndex;
        }
        if (filter.isGreaterThan()) {
            hql.append(filter.getKey()).append(" > ?").append(this.paramIndex);
            this.params.add(filter.getValue()[0]);
            ++this.paramIndex;
        }
        if (filter.isLessThan()) {
            hql.append(filter.getKey()).append(" < ?").append(this.paramIndex);
            this.params.add(filter.getValue()[0]);
            ++this.paramIndex;
        }
        if (filter.isGreaterThanEqual()) {
            hql.append(filter.getKey()).append(" >= ?").append(this.paramIndex);
            this.params.add(filter.getValue()[0]);
            ++this.paramIndex;
        }
        if (filter.isLessThanEqual()) {
            hql.append(filter.getKey()).append(" <= ?").append(this.paramIndex);
            this.params.add(filter.getValue()[0]);
            ++this.paramIndex;
        }
        if (filter.isBetween()) {
            hql.append(filter.getKey()).append(" BETWEEN ?").append(this.paramIndex).append(" AND ?").append(this.paramIndex + 1);
            this.params.add(filter.getValue()[0]);
            this.params.add(filter.getValue()[1]);
            this.paramIndex += 2;
        }
    }

    public Object[] getParams() {
        return this.params.toArray();
    }
}

