/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.CaseUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class JdbcQuery {
    private final JdbcTemplate jdbcTemplate;

    public JdbcQuery(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<Map<String, Object>> queryForList(String sql, Object ... params) {
        return this.jdbcTemplate.query(sql, params, (RowMapper)new CamelCaseRowMapper());
    }

    public <T> List<T> queryForList(String sql, Class<T> clazz, Object ... params) {
        return this.jdbcTemplate.query(sql, params, (RowMapper)new BeanPropertyRowMapper(clazz));
    }

    public <T> Page<T> queryForPage(String sql, String countSql, Class<T> clazz, PageRequest pageRequest, Object ... params) {
        List list = this.jdbcTemplate.query(sql, params, (RowMapper)new BeanPropertyRowMapper(clazz));
        long count = this.countQuery(countSql, params);
        return new PageImpl(list, (Pageable)pageRequest, count);
    }

    public <T> Page<T> queryForPage(String sql, Class<T> clazz, PageRequest pageRequest, Object ... params) {
        String countSql = "select count(1) " + sql;
        return this.queryForPage(sql, countSql, clazz, pageRequest, params);
    }

    public Page<Map<String, Object>> queryForPage(String sql, String countSql, PageRequest pageRequest, Object ... params) {
        List list = this.jdbcTemplate.query(sql, params, (RowMapper)new CamelCaseRowMapper());
        long count = this.countQuery(countSql, params);
        return new PageImpl(list, (Pageable)pageRequest, count);
    }

    public Page<Map<String, Object>> queryForPage(String sql, PageRequest pageRequest, Object ... params) {
        String countSql = "select count(1) " + sql;
        return this.queryForPage(sql, countSql, pageRequest, params);
    }

    private long countQuery(String sql, Object ... params) {
        int paramsLength = params.length;
        int countSqlParamsLength = sql.split("\\?").length - 1;
        Object[] newParams = new Object[countSqlParamsLength];
        if (paramsLength > countSqlParamsLength) {
            System.arraycopy(params, 0, newParams, 0, countSqlParamsLength);
        }
        return (Long)this.jdbcTemplate.queryForObject(sql, newParams, Long.class);
    }

    private static class CamelCaseRowMapper
    implements RowMapper<Map<String, Object>> {
        private CamelCaseRowMapper() {
        }

        public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            HashMap<String, Object> map = new HashMap<String, Object>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = metaData.getColumnLabel(i);
                map.put(CaseUtils.toCamelCase((String)columnName, (boolean)false, (char[])new char[0]), rs.getObject(i));
            }
            return map;
        }
    }
}

