/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.jpa.repository;

import com.codingapi.springboot.fast.jdbc.JdbcQueryContext;
import com.codingapi.springboot.fast.jpa.SQLBuilder;
import com.codingapi.springboot.fast.jpa.repository.BaseRepository;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface DynamicNativeRepository<T, ID>
extends BaseRepository<T, ID> {
    default public List<Map<String, Object>> dynamicNativeListMapQuery(SQLBuilder builder) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForMapList(builder);
    }

    default public List<Map<String, Object>> dynamicNativeListMapQuery(String sql, Object ... params) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForMapList(sql, params);
    }

    default public List<T> dynamicNativeListQuery(String sql, Object ... params) {
        return this.dynamicNativeListQuery(this.getEntityClass(), sql, params);
    }

    default public <V> List<V> dynamicNativeListQuery(Class<V> clazz, String sql, Object ... params) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForList(sql, clazz, params);
    }

    default public <V> List<V> dynamicNativeListQuery(SQLBuilder sqlBuilder) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForList(sqlBuilder);
    }

    default public Page<T> dynamicNativePageQuery(String sql, String countSql, PageRequest request, Object ... params) {
        return this.dynamicNativePageQuery(this.getEntityClass(), sql, countSql, request, params);
    }

    default public Page<T> dynamicNativePageQuery(String sql, PageRequest request, Object ... params) {
        return this.dynamicNativePageQuery(this.getEntityClass(), sql, request, params);
    }

    default public <V> Page<V> dynamicNativePageQuery(Class<V> clazz, String sql, String countSql, PageRequest request, Object ... params) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForPage(sql, countSql, clazz, request, params);
    }

    default public <V> Page<V> dynamicNativePageQuery(Class<V> clazz, String sql, PageRequest request, Object ... params) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForPage(sql, clazz, request, params);
    }

    default public <V> Page<V> dynamicNativePageQuery(SQLBuilder sqlBuilder, PageRequest request) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForPage(sqlBuilder, request);
    }

    default public Page<Map<String, Object>> dynamicNativeMapPageMapQuery(SQLBuilder sqlBuilder, PageRequest request) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForMapPage(sqlBuilder, request);
    }

    default public Page<Map<String, Object>> dynamicNativeMapPageMapQuery(String sql, String countSql, PageRequest request, Object ... params) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForMapPage(sql, countSql, request, params);
    }

    default public Page<Map<String, Object>> dynamicNativeMapPageMapQuery(String sql, PageRequest request, Object ... params) {
        return JdbcQueryContext.getInstance().getJdbcQuery().queryForMapPage(sql, request, params);
    }
}

