/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.query;

import com.codingapi.springboot.framework.dto.request.Filter;
import com.codingapi.springboot.framework.dto.request.PageRequest;
import com.codingapi.springboot.framework.dto.request.RequestFilter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Example;

public class QueryRequest {
    private final PageRequest request;
    private final Class<?> clazz;

    public QueryRequest(PageRequest request, Class<?> clazz) {
        this.request = request;
        this.clazz = clazz;
    }

    public <T> Example<T> getExample() {
        PropertyDescriptor[] descriptors;
        RequestFilter requestFilter = this.request.getRequestFilter();
        if (!requestFilter.hasFilter()) {
            return null;
        }
        Object entity = null;
        try {
            entity = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (PropertyDescriptor descriptor : descriptors = BeanUtils.getPropertyDescriptors(this.clazz)) {
            String name = descriptor.getName();
            Filter value = requestFilter.getFilter(name);
            if (value == null) continue;
            try {
                descriptor.getWriteMethod().invoke(entity, value.getFilterValue(descriptor.getPropertyType()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Example.of(entity);
    }

    private List<String> getClazzProperties() {
        PropertyDescriptor[] descriptors;
        ArrayList<String> properties = new ArrayList<String>();
        for (PropertyDescriptor descriptor : descriptors = BeanUtils.getPropertyDescriptors(this.clazz)) {
            properties.add(descriptor.getName());
        }
        return properties;
    }

    public <T> List<Order> getOrder(Root<T> root, CriteriaBuilder criteriaBuilder) {
        ArrayList<Order> orderList = new ArrayList<Order>();
        this.request.getSort().forEach(sort -> {
            if (sort.getDirection().isAscending()) {
                orderList.add(criteriaBuilder.asc((Expression)root.get(sort.getProperty())));
            } else {
                orderList.add(criteriaBuilder.asc((Expression)root.get(sort.getProperty())));
            }
        });
        return orderList;
    }

    private <T> Predicate toPredicate(Filter filter, CriteriaBuilder criteriaBuilder, Root<T> root, List<String> properties) {
        String key = filter.getKey();
        if (filter.isAndFilters() || filter.isOrFilters() || properties.contains(key)) {
            Filter[] orFilters;
            Object value;
            if (filter.isEqual()) {
                return criteriaBuilder.equal((Expression)root.get(key), filter.getValue()[0]);
            }
            if (filter.isLike()) {
                String matchValue = (String)filter.getValue()[0];
                return criteriaBuilder.like((Expression)root.get(key), "%" + matchValue + "%");
            }
            if (filter.isBetween()) {
                Object value1 = filter.getValue()[0];
                Object value2 = filter.getValue()[2];
                if (value1 instanceof Integer && value2 instanceof Integer) {
                    return criteriaBuilder.between((Expression)root.get(key), (Comparable)((Integer)value1), (Comparable)((Integer)value2));
                }
                if (value1 instanceof Long && value2 instanceof Long) {
                    return criteriaBuilder.between((Expression)root.get(key), (Comparable)((Long)value1), (Comparable)((Long)value2));
                }
                if (value1 instanceof Date && value2 instanceof Date) {
                    return criteriaBuilder.between((Expression)root.get(key), (Comparable)((Date)value1), (Comparable)((Date)value2));
                }
            }
            if (filter.isGreaterThan()) {
                value = filter.getValue()[0];
                if (value instanceof Integer) {
                    return criteriaBuilder.greaterThan((Expression)root.get(key), (Comparable)((Integer)value));
                }
                if (value instanceof Long) {
                    return criteriaBuilder.greaterThan((Expression)root.get(key), (Comparable)((Long)value));
                }
                if (value instanceof Date) {
                    return criteriaBuilder.greaterThan((Expression)root.get(key), (Comparable)((Date)value));
                }
            }
            if (filter.isGreaterThanEqual()) {
                value = filter.getValue()[0];
                if (value instanceof Integer) {
                    return criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(key), (Comparable)((Integer)value));
                }
                if (value instanceof Long) {
                    return criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(key), (Comparable)((Long)value));
                }
                if (value instanceof Date) {
                    return criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(key), (Comparable)((Date)value));
                }
            }
            if (filter.isLessThan()) {
                value = filter.getValue()[0];
                if (value instanceof Integer) {
                    return criteriaBuilder.lessThan((Expression)root.get(key), (Comparable)((Integer)value));
                }
                if (value instanceof Long) {
                    return criteriaBuilder.lessThan((Expression)root.get(key), (Comparable)((Long)value));
                }
                if (value instanceof Date) {
                    return criteriaBuilder.lessThan((Expression)root.get(key), (Comparable)((Date)value));
                }
            }
            if (filter.isLessThanEqual()) {
                value = filter.getValue()[0];
                if (value instanceof Integer) {
                    return criteriaBuilder.lessThanOrEqualTo((Expression)root.get(key), (Comparable)((Integer)value));
                }
                if (value instanceof Long) {
                    return criteriaBuilder.lessThanOrEqualTo((Expression)root.get(key), (Comparable)((Long)value));
                }
                if (value instanceof Date) {
                    return criteriaBuilder.lessThanOrEqualTo((Expression)root.get(key), (Comparable)((Date)value));
                }
            }
            if (filter.isIn()) {
                value = filter.getValue();
                CriteriaBuilder.In in = criteriaBuilder.in((Expression)root.get(key));
                for (Object item : value) {
                    in.value(item);
                }
                return in;
            }
            if (filter.isOrFilters()) {
                orFilters = (Filter[])filter.getValue();
                ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
                for (Filter orFilter : orFilters) {
                    Predicate predicate = this.toPredicate(orFilter, criteriaBuilder, root, properties);
                    if (predicate == null) continue;
                    orPredicates.add(predicate);
                }
                return criteriaBuilder.or(orPredicates.toArray(new Predicate[0]));
            }
            if (filter.isAndFilters()) {
                orFilters = (Filter[])filter.getValue();
                ArrayList<Predicate> addPredicates = new ArrayList<Predicate>();
                for (Filter orFilter : orFilters) {
                    Predicate predicate = this.toPredicate(orFilter, criteriaBuilder, root, properties);
                    if (predicate == null) continue;
                    addPredicates.add(predicate);
                }
                return criteriaBuilder.and(addPredicates.toArray(new Predicate[0]));
            }
        }
        return null;
    }

    public <T> List<Predicate> getPredicate(Root<T> root, CriteriaBuilder criteriaBuilder) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        List<String> properties = this.getClazzProperties();
        RequestFilter requestFilter = this.request.getRequestFilter();
        for (Filter filter : requestFilter.getFilters()) {
            Predicate predicate = this.toPredicate(filter, criteriaBuilder, root, properties);
            if (predicate == null) continue;
            predicates.add(predicate);
        }
        return predicates;
    }
}

