/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.jpa.repository;

import com.codingapi.springboot.fast.jpa.JpaQueryContext;
import java.util.List;
import org.springframework.core.ResolvableType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface DynamicRepository<T, ID>
extends JpaRepository<T, ID> {
    default public Class<?> getEntityClass() {
        ResolvableType resolvableType = ResolvableType.forClass(this.getClass()).as(DynamicRepository.class);
        return resolvableType.getGeneric(new int[]{0}).resolve();
    }

    default public List<T> dynamicListQuery(String sql, Object ... params) {
        return JpaQueryContext.getInstance().getJPAQuery().listQuery(this.getEntityClass(), sql, params);
    }

    default public <V> List<V> dynamicListQuery(Class<V> clazz, String sql, Object ... params) {
        return JpaQueryContext.getInstance().getJPAQuery().listQuery(clazz, sql, params);
    }

    default public Page<T> dynamicPageQuery(String sql, String countSql, PageRequest request, Object ... params) {
        return JpaQueryContext.getInstance().getJPAQuery().pageQuery(this.getEntityClass(), sql, countSql, request, params);
    }

    default public Page<T> dynamicPageQuery(String sql, PageRequest request, Object ... params) {
        return JpaQueryContext.getInstance().getJPAQuery().pageQuery(this.getEntityClass(), sql, "select count(1) " + sql, request, params);
    }

    default public <V> Page<V> dynamicPageQuery(Class<V> clazz, String sql, String countSql, PageRequest request, Object ... params) {
        return JpaQueryContext.getInstance().getJPAQuery().pageQuery(clazz, sql, countSql, request, params);
    }
}

