/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.jpa.repository;

import com.codingapi.springboot.fast.jpa.repository.DynamicRepository;
import com.codingapi.springboot.fast.jpa.repository.QueryRequest;
import com.codingapi.springboot.framework.dto.request.PageRequest;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.List;
import org.springframework.core.ResolvableType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface FastRepository<T, ID>
extends JpaRepository<T, ID>,
JpaSpecificationExecutor<T>,
DynamicRepository<T, ID> {
    default public Page<T> findAll(PageRequest request) {
        if (request.hasFilter()) {
            Class<T> clazz = this.getDomainClass();
            QueryRequest queryRequest = new QueryRequest(request, clazz);
            return this.findAll(queryRequest.getExample(), (Pageable)request);
        }
        return this.findAll((Pageable)request);
    }

    default public Class<T> getDomainClass() {
        ResolvableType resolvableType = ResolvableType.forClass(this.getClass()).as(FastRepository.class);
        return resolvableType.getGeneric(new int[]{0}).resolve();
    }

    default public Page<T> pageRequest(PageRequest request) {
        if (request.hasFilter()) {
            Class clazz = this.getDomainClass();
            Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
                QueryRequest queryRequest = new QueryRequest(request, clazz);
                List<Predicate> predicates = queryRequest.getPredicate(root, criteriaBuilder);
                List<Order> orderList = queryRequest.getOrder(root, criteriaBuilder);
                return query.where(predicates.toArray(new Predicate[0])).orderBy(orderList).getRestriction();
            };
            return this.findAll(specification, (Pageable)request);
        }
        return this.findAll((Pageable)request);
    }
}

