/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.jpa.repository;

import com.codingapi.springboot.framework.domain.ISort;
import com.codingapi.springboot.framework.dto.request.SortRequest;
import java.util.ArrayList;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface SortRepository<T extends ISort, ID>
extends JpaRepository<T, ID> {
    default public void reSort(SortRequest request) {
        if (request != null && !request.getIds().isEmpty()) {
            ArrayList<ISort> list = new ArrayList<ISort>();
            int minSort = Integer.MAX_VALUE;
            for (Object objectId : request.getIds()) {
                Object id = objectId;
                ISort t = (ISort)this.getReferenceById(id);
                if (t.getSort() == null) {
                    minSort = 0;
                } else if (t.getSort() < minSort) {
                    minSort = t.getSort();
                }
                list.add(t);
            }
            for (ISort t : list) {
                t.setSort(Integer.valueOf(minSort++));
            }
            this.saveAll(list);
        }
    }
}

