/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.script;

import com.codingapi.springboot.fast.script.ScriptMethod;
import com.codingapi.springboot.fast.script.ScriptRuntime;
import com.codingapi.springboot.framework.dto.response.MultiResponse;
import com.codingapi.springboot.framework.dto.response.Response;
import com.codingapi.springboot.framework.dto.response.SingleResponse;
import java.lang.reflect.Method;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.ResponseBody;

public class ScriptMapping {
    private String mapping;
    private ScriptMethod scriptMethod;
    private String script;

    public ScriptMapping(String mapping, ScriptMethod scriptMethod, String script) {
        this.mapping = mapping;
        this.scriptMethod = scriptMethod;
        this.script = script;
    }

    @ResponseBody
    Response execute() {
        Object result = ScriptRuntime.running(this.script);
        if (result instanceof List || result.getClass().isArray()) {
            return SingleResponse.of((Object)result);
        }
        if (result instanceof MultiResponse) {
            return (MultiResponse)result;
        }
        if (result instanceof Page) {
            return MultiResponse.of((Page)((Page)result));
        }
        return SingleResponse.of((Object)result);
    }

    Method getExecuteMethod() {
        try {
            return this.getClass().getDeclaredMethod("execute", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    @Generated
    public void setScriptMethod(ScriptMethod scriptMethod) {
        this.scriptMethod = scriptMethod;
    }

    @Generated
    public void setScript(String script) {
        this.script = script;
    }

    @Generated
    public String getMapping() {
        return this.mapping;
    }

    @Generated
    public ScriptMethod getScriptMethod() {
        return this.scriptMethod;
    }

    @Generated
    public String getScript() {
        return this.script;
    }
}

