/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.jpa;

import com.codingapi.springboot.fast.jpa.SQLBuilder;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class JPAQuery {
    private final EntityManager entityManager;

    public List<?> listQuery(SQLBuilder builder) {
        return this.listQuery(builder.getClazz(), builder.getSQL(), builder.getParams());
    }

    public List<?> listQuery(Class<?> clazz, String sql, Object ... params) {
        TypedQuery query = this.entityManager.createQuery(sql, clazz);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i + 1, params[i]);
            }
        }
        return query.getResultList();
    }

    public Page<?> pageQuery(SQLBuilder builder, PageRequest pageRequest) {
        return this.pageQuery(builder.getClazz(), builder.getSQL(), builder.getCountSQL(), pageRequest, builder.getParams());
    }

    public Page<?> pageQuery(Class<?> clazz, String sql, PageRequest pageRequest, Object ... params) {
        return this.pageQuery(clazz, sql, "select count(1) " + sql, pageRequest, params);
    }

    public Page<?> pageQuery(Class<?> clazz, String sql, String countSql, PageRequest pageRequest, Object ... params) {
        TypedQuery query = this.entityManager.createQuery(sql, clazz);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i + 1, params[i]);
            }
        }
        query.setFirstResult(pageRequest.getPageNumber() * pageRequest.getPageSize());
        query.setMaxResults(pageRequest.getPageSize());
        return new PageImpl(query.getResultList(), (Pageable)pageRequest, this.countQuery(countSql, params));
    }

    private long countQuery(String sql, Object ... params) {
        TypedQuery query = this.entityManager.createQuery(sql, Long.class);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i + 1, params[i]);
            }
        }
        return (Long)query.getSingleResult();
    }

    @Generated
    public JPAQuery(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

