/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.metadata;

import com.codingapi.springboot.fast.classloader.DynamicTableClassLoader;
import com.codingapi.springboot.fast.metadata.TableEntityMetadata;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import org.hibernate.annotations.Comment;
import org.springframework.util.StringUtils;

class TableEntityClassBuilder {
    private final TableEntityMetadata metadata;
    private DynamicType.Builder<?> builder;

    public TableEntityClassBuilder(TableEntityMetadata metadata) {
        if (metadata == null || metadata.getClassName() == null) {
            throw new IllegalArgumentException("Entity metadata cannot be null");
        }
        this.metadata = metadata;
        this.builder = new ByteBuddy().subclass(Object.class).name(metadata.getClassName()).implement(new Type[]{Serializable.class}).annotateType(this.buildEntityAnnotations());
    }

    public Class<?> build() {
        try {
            this.buildColumns();
            Class clazz = this.builder.make().load(TableEntityClassBuilder.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
            DynamicTableClassLoader.getInstance().registerClass(clazz);
            return clazz;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build dynamic entity: " + this.metadata.getClassName(), e);
        }
    }

    private void buildColumns() {
        for (TableEntityMetadata.ColumnMeta column : this.metadata.getColumns()) {
            this.addColumnField(column);
        }
    }

    private AnnotationDescription[] buildEntityAnnotations() {
        TableEntityMetadata.TableMeta tableMeta;
        ArrayList<AnnotationDescription> annotations = new ArrayList<AnnotationDescription>();
        annotations.add(AnnotationDescription.Builder.ofType(Entity.class).build());
        if (this.metadata.getTable() != null) {
            AnnotationDescription.Builder tableBuilder = AnnotationDescription.Builder.ofType(Table.class);
            tableMeta = this.metadata.getTable();
            if (tableMeta.getName() != null && !tableMeta.getName().isEmpty()) {
                tableBuilder = tableBuilder.define("name", tableMeta.getName());
            }
            if (tableMeta.getCatalog() != null && !tableMeta.getCatalog().isEmpty()) {
                tableBuilder = tableBuilder.define("catalog", tableMeta.getCatalog());
            }
            if (tableMeta.getSchema() != null && !tableMeta.getSchema().isEmpty()) {
                tableBuilder = tableBuilder.define("schema", tableMeta.getSchema());
            }
            annotations.add(tableBuilder.build());
        }
        if (this.metadata.getTable() != null && StringUtils.hasText((String)this.metadata.getTable().getComment())) {
            AnnotationDescription.Builder commentBuilder = AnnotationDescription.Builder.ofType(Comment.class);
            tableMeta = this.metadata.getTable();
            commentBuilder = commentBuilder.define("value", tableMeta.getComment());
            annotations.add(commentBuilder.build());
        }
        return annotations.toArray(new AnnotationDescription[0]);
    }

    private void addColumnField(TableEntityMetadata.ColumnMeta columnMeta) {
        Class<?> fieldType = columnMeta.getType();
        String fieldName = columnMeta.getFieldName();
        List<AnnotationDescription> fieldAnnotations = this.buildFieldAnnotations(columnMeta);
        this.builder = fieldAnnotations.isEmpty() ? this.builder.defineField(fieldName, fieldType, new ModifierContributor.ForField[]{Visibility.PRIVATE}) : this.builder.defineField(fieldName, fieldType, new ModifierContributor.ForField[]{Visibility.PRIVATE}).annotateField(fieldAnnotations.toArray(new AnnotationDescription[0]));
        String capitalizedFieldName = this.capitalize(fieldName);
        String getterName = "get" + capitalizedFieldName;
        String setterName = "set" + capitalizedFieldName;
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            getterName = "is" + capitalizedFieldName;
        }
        this.builder = this.builder.defineMethod(getterName, fieldType, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)FieldAccessor.ofField((String)fieldName));
        this.builder = this.builder.defineMethod(setterName, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameter(fieldType).intercept((Implementation)FieldAccessor.ofField((String)fieldName));
    }

    private List<AnnotationDescription> buildFieldAnnotations(TableEntityMetadata.ColumnMeta columnMeta) {
        ArrayList<AnnotationDescription> annotations = new ArrayList<AnnotationDescription>();
        if (columnMeta.isPrimaryKey()) {
            annotations.add(AnnotationDescription.Builder.ofType(Id.class).build());
            if (columnMeta.getGeneratedValue() != null) {
                TableEntityMetadata.GeneratedValueMeta genMeta = columnMeta.getGeneratedValue();
                AnnotationDescription.Builder genBuilder = AnnotationDescription.Builder.ofType(GeneratedValue.class);
                if (genMeta.getStrategy() != null) {
                    genBuilder = genBuilder.define("strategy", (Enum)genMeta.getStrategy());
                }
                if (genMeta.getGenerator() != null && !genMeta.getGenerator().isEmpty()) {
                    genBuilder = genBuilder.define("generator", genMeta.getGenerator());
                }
                annotations.add(genBuilder.build());
            }
        }
        AnnotationDescription.Builder columnBuilder = AnnotationDescription.Builder.ofType(Column.class);
        columnBuilder = columnBuilder.define("name", columnMeta.getColumnName()).define("nullable", columnMeta.isNullable()).define("unique", columnMeta.isUnique()).define("insertable", columnMeta.isInsertable()).define("updatable", columnMeta.isUpdatable());
        if (columnMeta.getLength() > 0) {
            columnBuilder = columnBuilder.define("length", columnMeta.getLength());
        }
        if (columnMeta.getPrecision() > 0) {
            columnBuilder = columnBuilder.define("precision", columnMeta.getPrecision());
        }
        if (columnMeta.getScale() > 0) {
            columnBuilder = columnBuilder.define("scale", columnMeta.getScale());
        }
        if (columnMeta.getColumnDefinition() != null && !columnMeta.getColumnDefinition().isEmpty()) {
            columnBuilder = columnBuilder.define("columnDefinition", columnMeta.getColumnDefinition());
        }
        annotations.add(columnBuilder.build());
        if (StringUtils.hasText((String)columnMeta.getComment())) {
            annotations.add(AnnotationDescription.Builder.ofType(Comment.class).define("value", columnMeta.getComment()).build());
        }
        return annotations;
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

