/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.metadata;

import com.codingapi.springboot.fast.metadata.TableEntityClassBuilder;
import jakarta.persistence.GenerationType;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class TableEntityMetadata {
    private final String className;
    private final TableMeta table;
    private final List<ColumnMeta> columns;

    public TableEntityMetadata(String className) {
        this.className = className;
        this.table = new TableMeta();
        this.columns = new ArrayList<ColumnMeta>();
    }

    public void setTable(String name, String catalog, String schema, String comment) {
        this.table.setName(name);
        this.table.setCatalog(catalog);
        this.table.setSchema(schema);
        this.table.setComment(comment);
    }

    public void setTable(String name, String comment) {
        this.setTable(name, null, null, comment);
    }

    public void setTable(String name) {
        this.setTable(name, null, null, null);
    }

    public void addPrimaryKeyColumn(Class<?> type, String fieldName, String columnName, GenerationType strategy, String generator, String comment, boolean unique, boolean nullable, boolean insertable, boolean updatable, String columnDefinition, int length, int precision, int scale) {
        ColumnMeta column = new ColumnMeta();
        column.setType(type);
        column.setFieldName(fieldName);
        column.setColumnName(columnName);
        column.setPrimaryKey(true);
        GeneratedValueMeta generatedValueMeta = new GeneratedValueMeta();
        generatedValueMeta.setGenerator(generator);
        generatedValueMeta.setStrategy(strategy);
        column.setGeneratedValue(generatedValueMeta);
        column.setComment(comment);
        column.setUnique(unique);
        column.setNullable(nullable);
        column.setInsertable(insertable);
        column.setUpdatable(updatable);
        column.setColumnDefinition(columnDefinition);
        column.setLength(length);
        column.setPrecision(precision);
        column.setScale(scale);
        this.columns.add(column);
    }

    public void addColumn(Class<?> type, String fieldName, String columnName, String comment, boolean unique, boolean nullable, boolean insertable, boolean updatable, String columnDefinition, int length, int precision, int scale) {
        ColumnMeta column = new ColumnMeta();
        column.setPrimaryKey(false);
        column.setType(type);
        column.setFieldName(fieldName);
        column.setColumnName(columnName);
        column.setComment(comment);
        column.setUnique(unique);
        column.setNullable(nullable);
        column.setInsertable(insertable);
        column.setUpdatable(updatable);
        column.setColumnDefinition(columnDefinition);
        column.setLength(length);
        column.setPrecision(precision);
        column.setScale(scale);
        this.columns.add(column);
    }

    public void addColumn(Class<?> type, String name, String comment) {
        this.addColumn(type, name, name, comment, false, false, false, false, null, 255, 0, 0);
    }

    public void addColumn(Class<?> type, String name) {
        this.addColumn(type, name, name, null, false, false, false, false, null, 255, 0, 0);
    }

    public void addPrimaryKeyColumn(Class<?> type, String name) {
        this.addPrimaryKeyColumn(type, name, name, null, null, null, false, false, false, false, null, 255, 0, 0);
    }

    public void addPrimaryKeyColumn(Class<?> type, String name, GenerationType strategy) {
        this.addPrimaryKeyColumn(type, name, name, strategy, null, null, false, false, false, false, null, 255, 0, 0);
    }

    public void addPrimaryKeyColumn(Class<?> type, String name, GenerationType strategy, String comment) {
        this.addPrimaryKeyColumn(type, name, name, strategy, null, comment, false, false, false, false, null, 255, 0, 0);
    }

    public void verify() {
        if (this.columns.isEmpty()) {
            throw new IllegalArgumentException("columns must not null.");
        }
        boolean hasPrimaryKey = false;
        for (ColumnMeta column : this.columns) {
            if (!column.isPrimaryKey) continue;
            hasPrimaryKey = true;
        }
        if (!hasPrimaryKey) {
            throw new IllegalArgumentException("columns must has primaryKey.");
        }
    }

    public Class<?> buildClass() {
        this.verify();
        TableEntityClassBuilder builder = new TableEntityClassBuilder(this);
        return builder.build();
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public TableMeta getTable() {
        return this.table;
    }

    @Generated
    public List<ColumnMeta> getColumns() {
        return this.columns;
    }

    public static class TableMeta {
        private String name;
        private String catalog;
        private String schema;
        private String comment;

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Generated
        public void setSchema(String schema) {
            this.schema = schema;
        }

        @Generated
        public void setComment(String comment) {
            this.comment = comment;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getCatalog() {
            return this.catalog;
        }

        @Generated
        public String getSchema() {
            return this.schema;
        }

        @Generated
        public String getComment() {
            return this.comment;
        }
    }

    public static class ColumnMeta {
        private Class<?> type;
        private String columnName;
        private String fieldName;
        private boolean isPrimaryKey;
        private GeneratedValueMeta generatedValue;
        private String comment;
        private boolean unique;
        private boolean nullable;
        private boolean insertable;
        private boolean updatable;
        private String columnDefinition;
        private int length;
        private int precision;
        private int scale;

        @Generated
        public void setType(Class<?> type) {
            this.type = type;
        }

        @Generated
        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Generated
        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Generated
        public void setPrimaryKey(boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
        }

        @Generated
        public void setGeneratedValue(GeneratedValueMeta generatedValue) {
            this.generatedValue = generatedValue;
        }

        @Generated
        public void setComment(String comment) {
            this.comment = comment;
        }

        @Generated
        public void setUnique(boolean unique) {
            this.unique = unique;
        }

        @Generated
        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        @Generated
        public void setInsertable(boolean insertable) {
            this.insertable = insertable;
        }

        @Generated
        public void setUpdatable(boolean updatable) {
            this.updatable = updatable;
        }

        @Generated
        public void setColumnDefinition(String columnDefinition) {
            this.columnDefinition = columnDefinition;
        }

        @Generated
        public void setLength(int length) {
            this.length = length;
        }

        @Generated
        public void setPrecision(int precision) {
            this.precision = precision;
        }

        @Generated
        public void setScale(int scale) {
            this.scale = scale;
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        public String getFieldName() {
            return this.fieldName;
        }

        @Generated
        public boolean isPrimaryKey() {
            return this.isPrimaryKey;
        }

        @Generated
        public GeneratedValueMeta getGeneratedValue() {
            return this.generatedValue;
        }

        @Generated
        public String getComment() {
            return this.comment;
        }

        @Generated
        public boolean isUnique() {
            return this.unique;
        }

        @Generated
        public boolean isNullable() {
            return this.nullable;
        }

        @Generated
        public boolean isInsertable() {
            return this.insertable;
        }

        @Generated
        public boolean isUpdatable() {
            return this.updatable;
        }

        @Generated
        public String getColumnDefinition() {
            return this.columnDefinition;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public int getPrecision() {
            return this.precision;
        }

        @Generated
        public int getScale() {
            return this.scale;
        }
    }

    public static class GeneratedValueMeta {
        private GenerationType strategy;
        private String generator;

        @Generated
        public void setStrategy(GenerationType strategy) {
            this.strategy = strategy;
        }

        @Generated
        public void setGenerator(String generator) {
            this.generator = generator;
        }

        @Generated
        public GenerationType getStrategy() {
            return this.strategy;
        }

        @Generated
        public String getGenerator() {
            return this.generator;
        }
    }
}

