/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.relational.ContributableDatabaseObject;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.SourceType;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.ExceptionHandlerCollectingImpl;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.SourceDescriptor;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.springframework.util.StringUtils;

public class DynamicTableGenerator {
    private final Class<?> dialect;
    private final StandardServiceRegistry serviceRegistry;
    private final SchemaManagementTool managementTool;

    public DynamicTableGenerator(Class<?> dialectClass, String jdbcUrl) {
        this(dialectClass, jdbcUrl, null, null);
    }

    public DynamicTableGenerator(Class<?> dialectClass, String jdbcUrl, String username, String password) {
        this.dialect = dialectClass;
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder().applySetting("hibernate.dialect", (Object)this.dialect.getName()).applySetting("hibernate.connection.url", (Object)jdbcUrl);
        if (StringUtils.hasText((String)username)) {
            builder.applySetting("hibernate.connection.username", (Object)username);
        }
        if (StringUtils.hasText((String)password)) {
            builder.applySetting("hibernate.connection.password", (Object)password);
        }
        this.serviceRegistry = builder.build();
        this.managementTool = (SchemaManagementTool)this.serviceRegistry.getService(SchemaManagementTool.class);
    }

    public String generateDropTableDDL(Class<?> entityClass) {
        return this.generateDropTableDDL(entityClass, false);
    }

    public String generateDropTableDDL(Class<?> entityClass, boolean executable) {
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)this.serviceRegistry);
        metadataSources.addAnnotatedClass(entityClass);
        Metadata metadata = metadataSources.buildMetadata();
        TargetDescriptorImpl targetDescriptor = new TargetDescriptorImpl(executable);
        this.managementTool.getSchemaDropper(Collections.emptyMap()).doDrop(metadata, (ExecutionOptions)new ExecutionOptionsImpl(), (ContributableMatcher)new ContributableMatcherImpl(), (SourceDescriptor)new SourceDescriptorImpl(), (TargetDescriptor)targetDescriptor);
        return targetDescriptor.getDDL();
    }

    public String generateCreateTableDDL(Class<?> entityClass) {
        return this.generateCreateTableDDL(entityClass, false);
    }

    public String generateCreateTableDDL(Class<?> entityClass, boolean executable) {
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)this.serviceRegistry);
        metadataSources.addAnnotatedClass(entityClass);
        Metadata metadata = metadataSources.buildMetadata();
        TargetDescriptorImpl targetDescriptor = new TargetDescriptorImpl(executable);
        this.managementTool.getSchemaCreator(Collections.emptyMap()).doCreation(metadata, (ExecutionOptions)new ExecutionOptionsImpl(), (ContributableMatcher)new ContributableMatcherImpl(), (SourceDescriptor)new SourceDescriptorImpl(), (TargetDescriptor)targetDescriptor);
        return targetDescriptor.getDDL();
    }

    public String generateMigratorTableDDL(Class<?> entityClass) {
        return this.generateMigratorTableDDL(entityClass, false);
    }

    public String generateMigratorTableDDL(Class<?> entityClass, boolean executable) {
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)this.serviceRegistry);
        metadataSources.addAnnotatedClass(entityClass);
        Metadata metadata = metadataSources.buildMetadata();
        TargetDescriptorImpl targetDescriptor = new TargetDescriptorImpl(executable);
        this.managementTool.getSchemaMigrator(Collections.emptyMap()).doMigration(metadata, (ExecutionOptions)new ExecutionOptionsImpl(), (ContributableMatcher)new ContributableMatcherImpl(), (TargetDescriptor)targetDescriptor);
        return targetDescriptor.getDDL();
    }

    public List<Exception> validatorTable(Class<?> entityClass) {
        final ExceptionHandlerCollectingImpl exceptionHandler = new ExceptionHandlerCollectingImpl();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)this.serviceRegistry);
        metadataSources.addAnnotatedClass(entityClass);
        Metadata metadata = metadataSources.buildMetadata();
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        try {
            this.managementTool.getSchemaValidator(Collections.emptyMap()).doValidation(metadata, (ExecutionOptions)new ExecutionOptionsImpl(){

                @Override
                public ExceptionHandler getExceptionHandler() {
                    return exceptionHandler;
                }
            }, (ContributableMatcher)new ContributableMatcherImpl());
        }
        catch (Exception e) {
            exceptionList.add(e);
        }
        exceptionList.addAll(exceptionHandler.getExceptions());
        return exceptionList;
    }

    private static class TargetDescriptorImpl
    implements TargetDescriptor {
        private final List<String> sqlCommands = new ArrayList<String>();
        private final boolean executable;

        public TargetDescriptorImpl(boolean executable) {
            this.executable = executable;
        }

        public EnumSet<TargetType> getTargetTypes() {
            EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.SCRIPT);
            if (this.executable) {
                targetTypes.add(TargetType.DATABASE);
            }
            return targetTypes;
        }

        public ScriptTargetOutput getScriptTargetOutput() {
            return new ScriptTargetOutput(){

                public void prepare() {
                }

                public void accept(String command) {
                    sqlCommands.add(command);
                }

                public void release() {
                }
            };
        }

        public String getDDL() {
            return String.join((CharSequence)"\n", this.sqlCommands);
        }
    }

    private class ExecutionOptionsImpl
    implements ExecutionOptions {
        private ExecutionOptionsImpl() {
        }

        public Map<String, Object> getConfigurationValues() {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("hibernate.dialect", DynamicTableGenerator.this.dialect.getName());
            return config;
        }

        public boolean shouldManageNamespaces() {
            return false;
        }

        public ExceptionHandler getExceptionHandler() {
            return new ExceptionHandlerCollectingImpl();
        }
    }

    private static class ContributableMatcherImpl
    implements ContributableMatcher {
        private ContributableMatcherImpl() {
        }

        public boolean matches(ContributableDatabaseObject contributed) {
            return true;
        }
    }

    private static class SourceDescriptorImpl
    implements SourceDescriptor {
        private SourceDescriptorImpl() {
        }

        public SourceType getSourceType() {
            return SourceType.METADATA;
        }

        public ScriptSourceInput getScriptSourceInput() {
            return extractor -> List.of();
        }
    }
}

