/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.fast.jpa.map;

import com.codingapi.springboot.framework.utils.RandomGenerator;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class QueryColumns {
    private final String key = RandomGenerator.randomString((int)8);
    private final List<String> columns = new ArrayList<String>();

    QueryColumns() {
    }

    public QueryColumns addColumn(String column) {
        this.columns.add(column);
        return this;
    }

    List<String> getColumnAlias() {
        ArrayList<String> columnAlias = new ArrayList<String>();
        for (String column : this.columns) {
            String alias;
            String[] parts;
            if (column.contains("as ")) {
                parts = column.split("as ");
                alias = parts[parts.length - 1];
                columnAlias.add(alias.trim());
                continue;
            }
            if (column.contains("AS ")) {
                parts = column.split("AS ");
                alias = parts[parts.length - 1];
                columnAlias.add(alias.trim());
                continue;
            }
            if (column.contains(".")) {
                parts = column.split("\\.");
                alias = parts[parts.length - 1];
                columnAlias.add(alias.trim());
                continue;
            }
            columnAlias.add(column.trim());
        }
        return columnAlias;
    }

    public String getColumnSql() {
        return String.join((CharSequence)",", this.columns);
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public List<String> getColumns() {
        return this.columns;
    }
}

