/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.domain;

import com.codingapi.springboot.flow.build.SchemaReader;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowRelation;
import com.codingapi.springboot.flow.serializable.FlowWorkSerializable;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.utils.RandomGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class FlowWork {
    private long id;
    private String code;
    private String title;
    private String description;
    private IFlowOperator createUser;
    private long createTime;
    private long updateTime;
    private boolean enable;
    private boolean skipIfSameApprover;
    private int postponedMax;
    private List<FlowNode> nodes;
    private List<FlowRelation> relations;
    private String schema;

    public FlowWork(IFlowOperator createUser) {
        this.createUser = createUser;
        this.createTime = System.currentTimeMillis();
        this.updateTime = System.currentTimeMillis();
        this.nodes = new ArrayList<FlowNode>();
        this.relations = new ArrayList<FlowRelation>();
        this.enable = false;
        this.postponedMax = 1;
        this.code = RandomGenerator.randomString((int)8);
    }

    public FlowWork copy() {
        String newId;
        if (!StringUtils.hasLength((String)this.schema)) {
            throw new IllegalArgumentException("schema is empty");
        }
        String schema = this.getSchema();
        for (FlowNode flowNode : this.getNodes()) {
            newId = RandomGenerator.generateUUID();
            schema = schema.replaceAll(flowNode.getId(), newId);
        }
        for (FlowRelation relation : this.getRelations()) {
            newId = RandomGenerator.generateUUID();
            schema = schema.replaceAll(relation.getId(), newId);
        }
        FlowWork flowWork = new FlowWork(this.createUser);
        flowWork.setDescription(this.getDescription());
        flowWork.setTitle(this.getTitle());
        flowWork.setCode(RandomGenerator.randomString((int)8));
        flowWork.setPostponedMax(this.getPostponedMax());
        flowWork.setSkipIfSameApprover(this.isSkipIfSameApprover());
        flowWork.schema(schema);
        return flowWork;
    }

    public FlowWork(String code, String title, String description, int postponedMax, IFlowOperator createUser) {
        this.title = title;
        this.code = code;
        this.description = description;
        this.postponedMax = postponedMax;
        this.createUser = createUser;
        this.createTime = System.currentTimeMillis();
        this.updateTime = System.currentTimeMillis();
        this.nodes = new ArrayList<FlowNode>();
        this.relations = new ArrayList<FlowRelation>();
        this.enable = false;
    }

    public void verify() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes is empty");
        }
        if (this.relations == null || this.relations.isEmpty()) {
            throw new IllegalArgumentException("relations is empty");
        }
        if (!StringUtils.hasLength((String)this.title)) {
            throw new IllegalArgumentException("title is empty");
        }
        if (!StringUtils.hasLength((String)this.code)) {
            throw new IllegalArgumentException("code is empty");
        }
        this.verifyNodes();
        this.verifyRelations();
        this.checkRelation();
    }

    private void checkRelation() {
        FlowNode startNode = this.getNodeByCode("start");
        if (startNode == null) {
            throw new IllegalArgumentException("start node is not exist");
        }
        FlowNode overNode = this.getNodeByCode("over");
        if (overNode == null) {
            throw new IllegalArgumentException("over node is not exist");
        }
        ArrayList<String> sourceCodes = new ArrayList<String>();
        ArrayList<String> targetCodes = new ArrayList<String>();
        for (FlowRelation relation : this.relations) {
            sourceCodes.add(relation.getSource().getCode());
            targetCodes.add(relation.getTarget().getCode());
        }
        if (!sourceCodes.contains("start")) {
            throw new IllegalArgumentException("start node relation is not exist");
        }
        if (!targetCodes.contains("over")) {
            throw new IllegalArgumentException("over node relation is not exist");
        }
    }

    private void verifyNodes() {
        ArrayList<String> nodeCodes = new ArrayList<String>();
        for (FlowNode node : this.nodes) {
            node.verify();
            if (nodeCodes.contains(node.getCode())) {
                throw new IllegalArgumentException("node code is exist");
            }
            nodeCodes.add(node.getCode());
        }
    }

    private void verifyRelations() {
        for (FlowRelation relation : this.relations) {
            relation.verify();
            relation.verifyNodes(this.nodes);
        }
    }

    public FlowWorkSerializable toSerializable() {
        return new FlowWorkSerializable(this.id, this.code, this.title, this.description, this.createUser.getUserId(), this.createTime, this.updateTime, this.skipIfSameApprover, this.enable, this.postponedMax, this.schema, this.nodes.stream().map(FlowNode::toSerializable).collect(Collectors.toCollection(ArrayList::new)), this.relations.stream().map(FlowRelation::toSerializable).collect(Collectors.toCollection(ArrayList::new)));
    }

    public void schema(String schema) {
        SchemaReader schemaReader = new SchemaReader(schema);
        this.relations = schemaReader.getFlowRelations();
        this.nodes = schemaReader.getFlowNodes();
        this.schema = schema;
        this.verify();
        this.updateTime = System.currentTimeMillis();
    }

    public void addNode(FlowNode node) {
        List codes = this.nodes.stream().map(FlowNode::getCode).collect(Collectors.toList());
        if (codes.contains(node.getCode())) {
            throw new IllegalArgumentException("node code is exist");
        }
        this.nodes.add(node);
        this.updateTime = System.currentTimeMillis();
    }

    public void addRelation(FlowRelation relation) {
        this.relations.add(relation);
        this.updateTime = System.currentTimeMillis();
    }

    public FlowNode getNodeByCode(String code) {
        for (FlowNode node : this.nodes) {
            if (!node.getCode().equals(code)) continue;
            return node;
        }
        return null;
    }

    public FlowNode getStartNode() {
        return this.getNodeByCode("start");
    }

    public boolean hasBackRelation(String sourceCode) {
        return this.relations.stream().filter(relation -> relation.getSource().getCode().equals(sourceCode)).anyMatch(FlowRelation::isBack);
    }

    public void enableValidate() {
        if (!this.isEnable()) {
            throw new IllegalArgumentException("flow work is disable");
        }
    }

    public void enable() {
        this.verify();
        this.enable = true;
    }

    public void disbale() {
        this.enable = false;
    }

    public long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public IFlowOperator getCreateUser() {
        return this.createUser;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isSkipIfSameApprover() {
        return this.skipIfSameApprover;
    }

    public int getPostponedMax() {
        return this.postponedMax;
    }

    public List<FlowNode> getNodes() {
        return this.nodes;
    }

    public List<FlowRelation> getRelations() {
        return this.relations;
    }

    public String getSchema() {
        return this.schema;
    }

    public FlowWork(long id, String code, String title, String description, IFlowOperator createUser, long createTime, long updateTime, boolean enable, boolean skipIfSameApprover, int postponedMax, List<FlowNode> nodes, List<FlowRelation> relations, String schema) {
        this.id = id;
        this.code = code;
        this.title = title;
        this.description = description;
        this.createUser = createUser;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.enable = enable;
        this.skipIfSameApprover = skipIfSameApprover;
        this.postponedMax = postponedMax;
        this.nodes = nodes;
        this.relations = relations;
        this.schema = schema;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSkipIfSameApprover(boolean skipIfSameApprover) {
        this.skipIfSameApprover = skipIfSameApprover;
    }

    public void setPostponedMax(int postponedMax) {
        this.postponedMax = postponedMax;
    }
}

