/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.record.FlowProcess;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowRemoveService {
    private final FlowWorkRepository flowWorkRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowProcessRepository flowProcessRepository;
    private final FlowBindDataRepository flowBindDataRepository;

    public void remove(long recordId, IFlowOperator currentOperator) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowWorkRepository, this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyFlowRecordNotFinish();
        flowRecordVerifyService.verifyFlowRecordIsTodo();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        FlowNode flowNode = flowRecordVerifyService.getFlowNode();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        if (!flowNode.isStartNode()) {
            throw new IllegalArgumentException("flow record not remove");
        }
        BindDataSnapshot bindDataSnapshot = this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        IBindData bindData = bindDataSnapshot.toBindData();
        FlowProcess flowProcess = this.flowProcessRepository.getFlowProcessByProcessId(flowRecord.getProcessId());
        flowProcess.voided();
        this.flowProcessRepository.save(flowProcess);
        List<FlowRecord> historyRecords = this.flowRecordRepository.findFlowRecordByProcessId(flowRecord.getProcessId());
        for (FlowRecord record : historyRecords) {
            record.delete();
        }
        this.flowRecordRepository.save(historyRecords);
        EventPusher.push((IEvent)new FlowApprovalEvent(11, flowRecord, currentOperator, flowWork, bindData), (boolean)true);
    }

    public FlowRemoveService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowProcessRepository flowProcessRepository, FlowBindDataRepository flowBindDataRepository) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.flowBindDataRepository = flowBindDataRepository;
    }
}

