/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.record.FlowProcess;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowVoidedService {
    private final FlowWorkRepository flowWorkRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowProcessRepository flowProcessRepository;
    private final FlowBindDataRepository flowBindDataRepository;

    public void voided(String processId, IFlowOperator currentOperator) {
        if (!currentOperator.isFlowManager()) {
            throw new IllegalArgumentException("current operator not flow manager");
        }
        FlowProcess flowProcess = this.flowProcessRepository.getFlowProcessByProcessId(processId);
        if (flowProcess.isVoided()) {
            throw new IllegalArgumentException("flow process already voided");
        }
        flowProcess.voided();
        this.flowProcessRepository.save(flowProcess);
        FlowRecord currentRecord = null;
        List<FlowRecord> flowRecords = this.flowRecordRepository.findFlowRecordByProcessId(processId);
        if (!flowRecords.isEmpty()) {
            for (FlowRecord flowRecord : flowRecords) {
                if (flowRecord.isFinish()) {
                    throw new IllegalArgumentException("flow record already finish");
                }
                flowRecord.delete();
                if (currentRecord != null && flowRecord.getId() <= currentRecord.getId()) continue;
                currentRecord = flowRecord;
            }
        }
        this.flowRecordRepository.save(flowRecords);
        FlowWork flowWork = null;
        IBindData bindData = null;
        if (currentRecord != null) {
            BindDataSnapshot dataSnapshot = this.flowBindDataRepository.getBindDataSnapshotById(currentRecord.getSnapshotId());
            if (dataSnapshot != null) {
                bindData = dataSnapshot.toBindData();
            }
            flowWork = this.flowWorkRepository.getFlowWorkByCode(currentRecord.getWorkCode());
        }
        EventPusher.push((IEvent)new FlowApprovalEvent(13, currentRecord, currentOperator, flowWork, bindData), (boolean)true);
    }

    public FlowVoidedService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowProcessRepository flowProcessRepository, FlowBindDataRepository flowBindDataRepository) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.flowBindDataRepository = flowBindDataRepository;
    }
}

