/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowRemoveService {
    private final FlowWorkRepository flowWorkRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowProcessRepository flowProcessRepository;

    public void remove(long recordId, IFlowOperator currentOperator) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowWorkRepository, this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyFlowRecordNotFinish();
        flowRecordVerifyService.verifyFlowRecordIsTodo();
        FlowNode flowNode = flowRecordVerifyService.getFlowNode();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        if (!flowNode.isStartNode()) {
            throw new IllegalArgumentException("flow record not remove");
        }
        this.flowProcessRepository.deleteByProcessId(flowRecord.getProcessId());
        this.flowRecordRepository.deleteByProcessId(flowRecord.getProcessId());
    }

    public FlowRemoveService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowProcessRepository flowProcessRepository) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowProcessRepository = flowProcessRepository;
    }
}

