/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.event;

import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.ISyncEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowApprovalEvent
implements ISyncEvent {
    private static final Logger log = LoggerFactory.getLogger(FlowApprovalEvent.class);
    public static final int STATE_CREATE = 1;
    public static final int STATE_PASS = 2;
    public static final int STATE_REJECT = 3;
    public static final int STATE_TRANSFER = 4;
    public static final int STATE_RECALL = 5;
    public static final int STATE_FINISH = 6;
    public static final int STATE_TODO = 7;
    public static final int STATE_URGE = 8;
    public static final int STATE_CIRCULATE = 9;
    public static final int STATE_SAVE = 10;
    private final int state;
    private final IFlowOperator operator;
    private final FlowRecord flowRecord;
    private final FlowWork flowWork;
    private final IBindData bindData;

    public FlowApprovalEvent(int state, FlowRecord flowRecord, IFlowOperator operator, FlowWork flowWork, IBindData bindData) {
        this.state = state;
        this.operator = operator;
        this.flowRecord = flowRecord;
        this.flowWork = flowWork;
        this.bindData = bindData;
        log.debug("FlowApprovalEvent:{}", (Object)this);
    }

    public boolean match(String matchKey) {
        return this.bindData.match(matchKey);
    }

    @Deprecated
    public boolean match(Class<?> clazz) {
        return this.bindData.match(clazz.getName());
    }

    public <T> T toJavaObject(Class<T> clazz) {
        return this.bindData.toJavaObject(clazz);
    }

    public boolean isUrge() {
        return this.state == 8;
    }

    public boolean isTodo() {
        return this.state == 7;
    }

    public boolean isSave() {
        return this.state == 10;
    }

    public boolean isCreate() {
        return this.state == 1;
    }

    public boolean isPass() {
        return this.state == 2;
    }

    public boolean isReject() {
        return this.state == 3;
    }

    public boolean isTransfer() {
        return this.state == 4;
    }

    public boolean isRecall() {
        return this.state == 5;
    }

    public boolean isFinish() {
        return this.state == 6;
    }

    public int getState() {
        return this.state;
    }

    public IFlowOperator getOperator() {
        return this.operator;
    }

    public FlowRecord getFlowRecord() {
        return this.flowRecord;
    }

    public FlowWork getFlowWork() {
        return this.flowWork;
    }

    public IBindData getBindData() {
        return this.bindData;
    }

    public String toString() {
        return "FlowApprovalEvent(state=" + this.getState() + ", operator=" + this.getOperator() + ", flowRecord=" + this.getFlowRecord() + ", flowWork=" + this.getFlowWork() + ", bindData=" + this.getBindData() + ")";
    }
}

