/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.script;

import com.codingapi.springboot.flow.utils.Sha256Utils;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GroovyShellContext {
    private static final GroovyShellContext instance = new GroovyShellContext();
    private static final GroovyShell groovyShell = new GroovyShell();
    private final Map<String, ShellScript> cache = new HashMap<String, ShellScript>();
    private static final ExecutorService threadPool = Executors.newFixedThreadPool(10);
    private static final int MAX_CACHE_SIZE = 10000;

    private GroovyShellContext() {
    }

    public ShellScript parse(String script) {
        String hash = Sha256Utils.generateSHA256(script);
        if (this.cache.containsKey(hash)) {
            return this.cache.get(hash);
        }
        if (this.cache.size() > 10000) {
            this.cache.clear();
        }
        ShellScript shellScript = new ShellScript(script);
        threadPool.submit(shellScript);
        this.cache.put(hash, shellScript);
        return shellScript;
    }

    public int size() {
        return this.cache.size();
    }

    public static GroovyShellContext getInstance() {
        return instance;
    }

    public static class ShellScript
    implements Runnable {
        private final String script;
        private Script runtime;

        public ShellScript(String script) {
            this.script = script;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invokeMethod(String run, Object params) {
            ShellScript shellScript = this;
            synchronized (shellScript) {
                if (this.runtime == null) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.runtime == null) {
                        this.runtime = groovyShell.parse(this.script);
                    }
                }
                return this.runtime.invokeMethod(run, params);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.runtime = groovyShell.parse(this.script);
            ShellScript shellScript = this;
            synchronized (shellScript) {
                this.notifyAll();
            }
        }

        public String getScript() {
            return this.script;
        }
    }
}

