/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.bind;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.springboot.flow.bind.IBindData;

public class BindDataSnapshot {
    private long id;
    private String snapshot;
    private long createTime;
    private String clazzName;

    public BindDataSnapshot(long id, IBindData bindData) {
        if (bindData == null) {
            throw new IllegalArgumentException("bind data is null");
        }
        this.snapshot = bindData.toJsonSnapshot();
        this.clazzName = bindData.getClass().getName();
        this.createTime = System.currentTimeMillis();
        this.id = id;
    }

    public BindDataSnapshot(IBindData bindData) {
        this(0L, bindData);
    }

    public IBindData toBindData() {
        try {
            return (IBindData)JSONObject.parseObject((String)this.snapshot, Class.forName(this.clazzName));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bind data error");
        }
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setClazzName(String clazzName) {
        this.clazzName = clazzName;
    }

    public long getId() {
        return this.id;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public BindDataSnapshot(long id, String snapshot, long createTime, String clazzName) {
        this.id = id;
        this.snapshot = snapshot;
        this.createTime = createTime;
        this.clazzName = clazzName;
    }
}

