/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.content;

import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.content.FlowSessionBeanProvider;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.error.NodeResult;
import com.codingapi.springboot.flow.error.OperatorResult;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.List;

public class FlowSession {
    private final FlowWork flowWork;
    private final FlowNode flowNode;
    private final IFlowOperator createOperator;
    private final IFlowOperator currentOperator;
    private final IBindData bindData;
    private final Opinion opinion;
    private final List<FlowRecord> historyRecords;
    private final FlowSessionBeanProvider provider;

    public FlowSession(FlowWork flowWork, FlowNode flowNode, IFlowOperator createOperator, IFlowOperator currentOperator, IBindData bindData, Opinion opinion, List<FlowRecord> historyRecords) {
        this.flowWork = flowWork;
        this.flowNode = flowNode;
        this.createOperator = createOperator;
        this.currentOperator = currentOperator;
        this.bindData = bindData;
        this.opinion = opinion;
        this.historyRecords = historyRecords;
        this.provider = FlowSessionBeanProvider.getInstance();
    }

    public Object getBean(String beanName) {
        return this.provider.getBean(beanName);
    }

    public NodeResult createNodeErrTrigger(String nodeCode) {
        return new NodeResult(nodeCode);
    }

    public OperatorResult createOperatorErrTrigger(List<Long> operatorIds) {
        return new OperatorResult(operatorIds);
    }

    public OperatorResult createOperatorErrTrigger(long ... operatorIds) {
        return new OperatorResult(operatorIds);
    }

    public FlowWork getFlowWork() {
        return this.flowWork;
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public IFlowOperator getCreateOperator() {
        return this.createOperator;
    }

    public IFlowOperator getCurrentOperator() {
        return this.currentOperator;
    }

    public IBindData getBindData() {
        return this.bindData;
    }

    public Opinion getOpinion() {
        return this.opinion;
    }

    public List<FlowRecord> getHistoryRecords() {
        return this.historyRecords;
    }

    public FlowSessionBeanProvider getProvider() {
        return this.provider;
    }
}

