/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.pojo;

import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FlowResult {
    private final List<FlowRecord> records;
    private final FlowWork flowWork;

    public FlowResult(FlowWork flowWork, List<FlowRecord> records) {
        this.flowWork = flowWork;
        this.records = records;
    }

    public FlowResult(FlowWork flowWork, FlowRecord flowRecord) {
        this.flowWork = flowWork;
        this.records = new ArrayList<FlowRecord>();
        this.records.add(flowRecord);
    }

    public List<FlowRecord> matchRecordByOperator(IFlowOperator operator) {
        return this.records.stream().filter(record -> record.isOperator(operator)).collect(Collectors.toList());
    }

    public List<FlowRecord> getRecords() {
        return this.records;
    }

    public FlowWork getFlowWork() {
        return this.flowWork;
    }
}

