/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.matcher;

import com.codingapi.springboot.flow.content.FlowSession;
import com.codingapi.springboot.flow.script.GroovyShellContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class OperatorMatcher {
    private final String script;
    private final int state;
    private final GroovyShellContext.ShellScript runtime;
    public static final int STATE_SPECIFY = 1;
    public static final int STATE_CREATOR = 2;
    public static final int STATE_ANY = 3;

    public boolean isAny() {
        return this.state == 3;
    }

    public boolean isCreator() {
        return this.state == 2;
    }

    public boolean isSpecify() {
        return this.state == 1;
    }

    private static int parseState(String script) {
        if (script.contains("content.getCurrentOperator().getUserId()")) {
            return 3;
        }
        if (script.contains("content.getCreateOperator().getUserId()")) {
            return 2;
        }
        return 1;
    }

    public OperatorMatcher(String script) {
        this(script, OperatorMatcher.parseState(script));
    }

    public OperatorMatcher(String script, int state) {
        if (!StringUtils.hasLength((String)script)) {
            throw new IllegalArgumentException("script is empty");
        }
        this.script = script;
        this.state = state;
        this.runtime = GroovyShellContext.getInstance().parse(script);
    }

    public static OperatorMatcher anyOperatorMatcher() {
        return new OperatorMatcher("def run(content) {return [content.getCurrentOperator().getUserId()];}", 3);
    }

    public static OperatorMatcher specifyOperatorMatcher(long ... userIds) {
        String userIdsStr = Arrays.stream(userIds).mapToObj(String::valueOf).collect(Collectors.joining(","));
        return new OperatorMatcher("def run(content) {return [" + userIdsStr + "];}", 1);
    }

    public static OperatorMatcher specifyOperatorMatcher(List<Long> userIds) {
        String userIdsStr = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        return new OperatorMatcher("def run(content) {return [" + userIdsStr + "];}", 1);
    }

    public static OperatorMatcher creatorOperatorMatcher() {
        return new OperatorMatcher("def run(content) {return [content.getCreateOperator().getUserId()];}", 2);
    }

    public List<Long> matcher(FlowSession flowSession) {
        List values = (List)this.runtime.invokeMethod("run", flowSession);
        if (values == null) {
            return new ArrayList<Long>();
        }
        return values.stream().map(item -> {
            if (item instanceof Number) {
                return ((Number)item).longValue();
            }
            return Long.parseLong(item.toString());
        }).collect(Collectors.toList());
    }

    public String getScript() {
        return this.script;
    }
}

