/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.em.FlowType;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowServiceRepositoryHolder;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowNotifyService {
    private final String processId;
    private final IFlowOperator currentOperator;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowBindDataRepository flowBindDataRepository;
    private final FlowWorkRepository flowWorkRepository;
    private final FlowProcessRepository flowProcessRepository;

    public FlowNotifyService(String processId, IFlowOperator currentOperator, FlowServiceRepositoryHolder flowServiceRepositoryHolder) {
        this.processId = processId;
        this.currentOperator = currentOperator;
        this.flowRecordRepository = flowServiceRepositoryHolder.getFlowRecordRepository();
        this.flowBindDataRepository = flowServiceRepositoryHolder.getFlowBindDataRepository();
        this.flowWorkRepository = flowServiceRepositoryHolder.getFlowWorkRepository();
        this.flowProcessRepository = flowServiceRepositoryHolder.getFlowProcessRepository();
    }

    public FlowWork loadFlowWork(FlowRecord flowRecord) {
        FlowWork flowWork = this.flowProcessRepository.getFlowWorkByProcessId(flowRecord.getProcessId());
        if (flowWork == null) {
            flowWork = this.flowWorkRepository.getFlowWorkByCode(flowRecord.getWorkCode());
        }
        if (flowWork == null) {
            throw new IllegalArgumentException("flow work not found");
        }
        flowWork.enableValidate();
        return flowWork;
    }

    public void notifyFlow() {
        List<FlowRecord> flowRecords = this.flowRecordRepository.findFlowRecordByProcessId(this.processId);
        List waitingRecords = flowRecords.stream().filter(FlowRecord::isWaiting).collect(Collectors.toList());
        for (FlowRecord flowRecord : waitingRecords) {
            if (!flowRecord.isOperator(this.currentOperator)) continue;
            flowRecord.setFlowType(FlowType.TODO);
            this.flowRecordRepository.update(flowRecord);
            BindDataSnapshot snapshot = this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
            FlowWork flowWork = this.loadFlowWork(flowRecord);
            EventPusher.push((IEvent)new FlowApprovalEvent(7, flowRecord, flowRecord.getCurrentOperator(), flowWork, snapshot.toBindData()), (boolean)true);
        }
    }
}

