/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.pojo;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.List;
import java.util.stream.Collectors;

public class FlowDetail {
    private final FlowRecord flowRecord;
    private final FlowWork flowWork;
    private final FlowNode flowNode;
    private final List<FlowRecord> historyRecords;
    private final IBindData bindData;
    private final List<? extends IFlowOperator> operators;
    private final IFlowOperator flowCreator;
    private final long flowCreateTime;
    private final List<FlowOpinion> opinions;
    private final boolean canHandle;

    public FlowDetail(FlowRecord flowRecord, BindDataSnapshot snapshot, FlowWork flowWork, List<FlowRecord> historyRecords, List<? extends IFlowOperator> operators, boolean canHandle) {
        this.operators = operators;
        this.flowRecord = flowRecord;
        this.flowWork = flowWork;
        this.bindData = snapshot.toBindData();
        this.historyRecords = historyRecords;
        this.opinions = historyRecords.stream().map(x$0 -> new FlowOpinion((FlowRecord)x$0)).collect(Collectors.toList());
        this.flowCreator = flowRecord.getCreateOperator();
        this.flowCreateTime = flowRecord.getCreateTime();
        this.flowNode = flowWork.getNodeByCode(flowRecord.getNodeCode());
        this.canHandle = canHandle;
    }

    public FlowDetail(FlowWork flowWork, FlowNode flowNode, List<? extends IFlowOperator> operators, boolean canHandle) {
        this.flowWork = flowWork;
        this.flowNode = flowNode;
        this.operators = operators;
        this.flowCreateTime = 0L;
        this.flowRecord = null;
        this.historyRecords = null;
        this.bindData = null;
        this.opinions = null;
        this.flowCreator = null;
        this.canHandle = canHandle;
    }

    public FlowRecord getFlowRecord() {
        return this.flowRecord;
    }

    public FlowWork getFlowWork() {
        return this.flowWork;
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public List<FlowRecord> getHistoryRecords() {
        return this.historyRecords;
    }

    public IBindData getBindData() {
        return this.bindData;
    }

    public List<? extends IFlowOperator> getOperators() {
        return this.operators;
    }

    public IFlowOperator getFlowCreator() {
        return this.flowCreator;
    }

    public long getFlowCreateTime() {
        return this.flowCreateTime;
    }

    public List<FlowOpinion> getOpinions() {
        return this.opinions;
    }

    public boolean isCanHandle() {
        return this.canHandle;
    }

    public final class FlowOpinion {
        private final long recordId;
        private final Opinion opinion;
        private final String nodeCode;
        private final String nodeName;
        private final IFlowOperator operator;
        private final long createTime;

        public FlowOpinion(FlowRecord flowRecord) {
            this.nodeCode = flowRecord.getNodeCode();
            this.nodeName = FlowDetail.this.flowWork.getNodeByCode(this.nodeCode).getName();
            this.recordId = flowRecord.getId();
            this.opinion = flowRecord.getOpinion();
            this.operator = flowRecord.getCurrentOperator();
            this.createTime = flowRecord.getUpdateTime();
        }

        public long getRecordId() {
            return this.recordId;
        }

        public Opinion getOpinion() {
            return this.opinion;
        }

        public String getNodeCode() {
            return this.nodeCode;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public IFlowOperator getOperator() {
            return this.operator;
        }

        public long getCreateTime() {
            return this.createTime;
        }
    }
}

