/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.record;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.em.FlowStatus;
import com.codingapi.springboot.flow.em.FlowType;
import com.codingapi.springboot.flow.user.IFlowOperator;

public class FlowRecord {
    private long id;
    private long preId;
    private long workId;
    private String workCode;
    private String processId;
    private String nodeCode;
    private String title;
    private IFlowOperator currentOperator;
    private FlowType flowType;
    private FlowSourceDirection flowSourceDirection;
    private long createTime;
    private long updateTime;
    private long finishTime;
    private long timeoutTime;
    private int postponedCount;
    private IFlowOperator createOperator;
    private Opinion opinion;
    private FlowStatus flowStatus;
    private String errMessage;
    private String bindClass;
    private long snapshotId;
    private boolean read;
    private boolean interfere;
    private IFlowOperator interferedOperator;
    private long readTime;

    public void postponedTime(int postponedMax, long time) {
        if (this.postponedCount >= postponedMax) {
            throw new IllegalArgumentException("postponed count is max");
        }
        this.read();
        if (this.timeoutTime == 0L) {
            this.timeoutTime = System.currentTimeMillis();
        }
        this.timeoutTime += time;
        ++this.postponedCount;
        this.updateTime = System.currentTimeMillis();
    }

    public boolean isInitiated() {
        return this.preId == 0L && this.nodeCode.equals("start");
    }

    public void read() {
        this.read = true;
        this.readTime = System.currentTimeMillis();
    }

    public boolean isUnRead() {
        return !this.read;
    }

    public void updateOpinion(Opinion opinion) {
        this.opinion = opinion;
        this.updateTime = System.currentTimeMillis();
    }

    public void submitStateVerify() {
        if (this.flowStatus == FlowStatus.FINISH) {
            throw new IllegalArgumentException("flow is finish");
        }
        if (this.flowType == FlowType.DONE) {
            throw new IllegalArgumentException("flow is done");
        }
    }

    public void submitRecord(IFlowOperator flowOperator, BindDataSnapshot snapshot, Opinion opinion, FlowSourceDirection flowSourceDirection) {
        if (!flowOperator.isFlowManager()) {
            if (flowOperator.getUserId() != this.currentOperator.getUserId()) {
                throw new IllegalArgumentException("current operator is not match");
            }
        } else {
            this.interferedOperator = this.currentOperator;
            this.currentOperator = flowOperator;
            this.interfere = true;
        }
        this.read();
        this.flowSourceDirection = flowSourceDirection;
        this.flowType = FlowType.DONE;
        this.updateTime = System.currentTimeMillis();
        this.snapshotId = snapshot.getId();
        this.bindClass = snapshot.getClazzName();
        this.opinion = opinion;
    }

    public void circulate() {
        this.flowSourceDirection = FlowSourceDirection.CIRCULATE;
        this.flowType = FlowType.CIRCULATE;
        this.updateTime = System.currentTimeMillis();
        this.opinion = Opinion.circulate();
    }

    public void transfer(IFlowOperator flowOperator, BindDataSnapshot snapshot, Opinion opinion) {
        if (flowOperator.getUserId() != this.currentOperator.getUserId()) {
            throw new IllegalArgumentException("current operator is not match");
        }
        this.read();
        this.flowSourceDirection = FlowSourceDirection.TRANSFER;
        this.flowType = FlowType.TRANSFER;
        this.updateTime = System.currentTimeMillis();
        this.snapshotId = snapshot.getId();
        this.bindClass = snapshot.getClazzName();
        this.opinion = opinion;
    }

    public void transferToTodo(String title, IFlowOperator operator) {
        this.id = 0L;
        this.flowType = FlowType.TODO;
        this.flowStatus = FlowStatus.RUNNING;
        this.postponedCount = 0;
        this.updateTime = 0L;
        this.readTime = 0L;
        this.read = false;
        this.title = title;
        this.opinion = null;
        this.flowSourceDirection = null;
        this.interfere = false;
        this.interferedOperator = null;
        this.currentOperator = operator;
    }

    public void autoPass(IFlowOperator flowOperator, BindDataSnapshot snapshot) {
        this.read();
        this.flowSourceDirection = FlowSourceDirection.PASS;
        this.currentOperator = flowOperator;
        this.flowType = FlowType.DONE;
        this.updateTime = System.currentTimeMillis();
        this.snapshotId = snapshot.getId();
        this.bindClass = snapshot.getClazzName();
        this.opinion = Opinion.unSignAutoSuccess();
    }

    public void finish() {
        this.flowStatus = FlowStatus.FINISH;
        this.finishTime = System.currentTimeMillis();
    }

    public boolean isDone() {
        return this.flowType == FlowType.DONE;
    }

    public boolean isFinish() {
        return this.flowStatus == FlowStatus.FINISH;
    }

    public boolean isWaiting() {
        return this.flowType == FlowType.WAITING;
    }

    public boolean isTodo() {
        return this.flowType == FlowType.TODO && this.flowStatus == FlowStatus.RUNNING;
    }

    public boolean isTransfer() {
        return this.flowType == FlowType.TRANSFER;
    }

    public boolean isReject() {
        return this.opinion != null && this.opinion.isReject() && this.isDone();
    }

    public boolean isPass() {
        return this.opinion != null && this.opinion.isSuccess() && this.isDone();
    }

    public void matcherOperator(IFlowOperator currentOperator) {
        if (!this.isOperator(currentOperator)) {
            throw new IllegalArgumentException("current operator is not match");
        }
    }

    public boolean isOperator(IFlowOperator operator) {
        return this.currentOperator.getUserId() == operator.getUserId();
    }

    public void recall() {
        this.flowType = FlowType.TODO;
        this.updateTime = System.currentTimeMillis();
    }

    public FlowRecord copy() {
        FlowRecord record = new FlowRecord();
        record.setId(this.id);
        record.setPostponedCount(this.postponedCount);
        record.setPreId(this.preId);
        record.setWorkId(this.workId);
        record.setWorkCode(this.workCode);
        record.setProcessId(this.processId);
        record.setNodeCode(this.nodeCode);
        record.setTitle(this.title);
        record.setCurrentOperator(this.currentOperator);
        record.setFlowType(this.flowType);
        record.setFlowSourceDirection(this.flowSourceDirection);
        record.setCreateTime(this.createTime);
        record.setUpdateTime(this.updateTime);
        record.setFinishTime(this.finishTime);
        record.setTimeoutTime(this.timeoutTime);
        record.setCreateOperator(this.createOperator);
        record.setOpinion(this.opinion);
        record.setFlowStatus(this.flowStatus);
        record.setErrMessage(this.errMessage);
        record.setBindClass(this.bindClass);
        record.setSnapshotId(this.snapshotId);
        record.setRead(this.read);
        record.setInterfere(this.interfere);
        record.setInterferedOperator(this.interferedOperator);
        record.setReadTime(this.readTime);
        return record;
    }

    public boolean isTimeout() {
        if (this.timeoutTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() > this.timeoutTime;
    }

    public boolean isPostponed() {
        return this.postponedCount > 0;
    }

    public boolean isStartRecord() {
        return this.preId == 0L;
    }

    public boolean isOverNode() {
        return this.nodeCode.equals("over");
    }

    public boolean isStartNode() {
        return this.nodeCode.equals("start");
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setPreId(long preId) {
        this.preId = preId;
    }

    public void setWorkId(long workId) {
        this.workId = workId;
    }

    public void setWorkCode(String workCode) {
        this.workCode = workCode;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setNodeCode(String nodeCode) {
        this.nodeCode = nodeCode;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCurrentOperator(IFlowOperator currentOperator) {
        this.currentOperator = currentOperator;
    }

    public void setFlowType(FlowType flowType) {
        this.flowType = flowType;
    }

    public void setFlowSourceDirection(FlowSourceDirection flowSourceDirection) {
        this.flowSourceDirection = flowSourceDirection;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public void setTimeoutTime(long timeoutTime) {
        this.timeoutTime = timeoutTime;
    }

    public void setPostponedCount(int postponedCount) {
        this.postponedCount = postponedCount;
    }

    public void setCreateOperator(IFlowOperator createOperator) {
        this.createOperator = createOperator;
    }

    public void setOpinion(Opinion opinion) {
        this.opinion = opinion;
    }

    public void setFlowStatus(FlowStatus flowStatus) {
        this.flowStatus = flowStatus;
    }

    public void setErrMessage(String errMessage) {
        this.errMessage = errMessage;
    }

    public void setBindClass(String bindClass) {
        this.bindClass = bindClass;
    }

    public void setSnapshotId(long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void setInterfere(boolean interfere) {
        this.interfere = interfere;
    }

    public void setInterferedOperator(IFlowOperator interferedOperator) {
        this.interferedOperator = interferedOperator;
    }

    public void setReadTime(long readTime) {
        this.readTime = readTime;
    }

    public long getId() {
        return this.id;
    }

    public long getPreId() {
        return this.preId;
    }

    public long getWorkId() {
        return this.workId;
    }

    public String getWorkCode() {
        return this.workCode;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getNodeCode() {
        return this.nodeCode;
    }

    public String getTitle() {
        return this.title;
    }

    public IFlowOperator getCurrentOperator() {
        return this.currentOperator;
    }

    public FlowType getFlowType() {
        return this.flowType;
    }

    public FlowSourceDirection getFlowSourceDirection() {
        return this.flowSourceDirection;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    public int getPostponedCount() {
        return this.postponedCount;
    }

    public IFlowOperator getCreateOperator() {
        return this.createOperator;
    }

    public Opinion getOpinion() {
        return this.opinion;
    }

    public FlowStatus getFlowStatus() {
        return this.flowStatus;
    }

    public String getErrMessage() {
        return this.errMessage;
    }

    public String getBindClass() {
        return this.bindClass;
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean isInterfere() {
        return this.interfere;
    }

    public IFlowOperator getInterferedOperator() {
        return this.interferedOperator;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public String toString() {
        return "FlowRecord(id=" + this.getId() + ", preId=" + this.getPreId() + ", workId=" + this.getWorkId() + ", workCode=" + this.getWorkCode() + ", processId=" + this.getProcessId() + ", nodeCode=" + this.getNodeCode() + ", title=" + this.getTitle() + ", currentOperator=" + this.getCurrentOperator() + ", flowType=" + (Object)((Object)this.getFlowType()) + ", flowSourceDirection=" + (Object)((Object)this.getFlowSourceDirection()) + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", finishTime=" + this.getFinishTime() + ", timeoutTime=" + this.getTimeoutTime() + ", postponedCount=" + this.getPostponedCount() + ", createOperator=" + this.getCreateOperator() + ", opinion=" + this.getOpinion() + ", flowStatus=" + (Object)((Object)this.getFlowStatus()) + ", errMessage=" + this.getErrMessage() + ", bindClass=" + this.getBindClass() + ", snapshotId=" + this.getSnapshotId() + ", read=" + this.isRead() + ", interfere=" + this.isInterfere() + ", interferedOperator=" + this.getInterferedOperator() + ", readTime=" + this.getReadTime() + ")";
    }
}

