/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.domain;

import java.util.ArrayList;
import java.util.List;

public class Opinion {
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_AUTO = 1;
    public static final int RESULT_SAVE = 0;
    public static final int RESULT_TRANSFER = 1;
    public static final int RESULT_PASS = 2;
    public static final int RESULT_REJECT = 3;
    public static final int RESULT_CIRCULATE = 4;
    private String advice;
    private int result;
    private int type;
    private List<Long> operatorIds;

    public Opinion(String advice, int result, int type) {
        this.advice = advice;
        this.result = result;
        this.type = type;
    }

    public Opinion specify(List<Long> operatorIds) {
        this.operatorIds = operatorIds;
        return this;
    }

    public Opinion specify(long ... operatorIds) {
        ArrayList<Long> operatorIdList = new ArrayList<Long>();
        for (long operatorId : operatorIds) {
            operatorIdList.add(operatorId);
        }
        return this.specify(operatorIdList);
    }

    public static Opinion save(String advice) {
        return new Opinion(advice, 0, 0);
    }

    public static Opinion pass(String advice) {
        return new Opinion(advice, 2, 0);
    }

    public static Opinion reject(String advice) {
        return new Opinion(advice, 3, 0);
    }

    public static Opinion transfer(String advice) {
        return new Opinion(advice, 1, 0);
    }

    public static Opinion unSignAutoSuccess() {
        return new Opinion("\u975e\u4f1a\u7b7e\u81ea\u52a8\u5ba1\u6279", 2, 1);
    }

    public static Opinion circulate() {
        return new Opinion("", 4, 1);
    }

    public boolean isCirculate() {
        return this.result == 4;
    }

    public boolean isSuccess() {
        return this.result == 2;
    }

    public boolean isReject() {
        return this.result == 3;
    }

    public String getAdvice() {
        return this.advice;
    }

    public int getResult() {
        return this.result;
    }

    public int getType() {
        return this.type;
    }

    public List<Long> getOperatorIds() {
        return this.operatorIds;
    }

    public void setAdvice(String advice) {
        this.advice = advice;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setOperatorIds(List<Long> operatorIds) {
        this.operatorIds = operatorIds;
    }

    public String toString() {
        return "Opinion(advice=" + this.getAdvice() + ", result=" + this.getResult() + ", type=" + this.getType() + ", operatorIds=" + this.getOperatorIds() + ")";
    }

    public Opinion() {
    }
}

