/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service;

import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.record.FlowRecord;
import java.util.List;

public class FlowDirectionService {
    private final FlowWork flowWork;
    private final FlowNode flowNode;
    private final Opinion opinion;
    private FlowSourceDirection flowSourceDirection;
    private List<FlowRecord> historyRecords;

    public FlowDirectionService(FlowNode flowNode, FlowWork flowWork, Opinion opinion) {
        this.flowNode = flowNode;
        this.opinion = opinion;
        this.flowWork = flowWork;
    }

    public void bindHistoryRecords(List<FlowRecord> historyRecords) {
        this.historyRecords = historyRecords;
    }

    public void loadFlowSourceDirection() {
        if (this.opinion.isSuccess()) {
            this.flowSourceDirection = FlowSourceDirection.PASS;
        }
        if (this.opinion.isReject()) {
            this.flowSourceDirection = FlowSourceDirection.REJECT;
        }
    }

    public FlowSourceDirection reloadFlowSourceDirection() {
        boolean allPass;
        if (this.flowNode.isSign() && !(allPass = this.historyRecords.stream().filter(item -> !item.isTransfer()).allMatch(FlowRecord::isPass))) {
            this.flowSourceDirection = FlowSourceDirection.REJECT;
        }
        return this.flowSourceDirection;
    }

    public void verifyFlowSourceDirection() {
        if (this.flowSourceDirection == null) {
            throw new IllegalArgumentException("flow source direction is null");
        }
        if (this.flowNode.isStartNode() && this.flowSourceDirection == FlowSourceDirection.REJECT) {
            throw new IllegalArgumentException("flow node is start node");
        }
    }

    public boolean hasCurrentFlowNodeIsDone() {
        return this.historyRecords.stream().filter(item -> !item.isTransfer()).allMatch(FlowRecord::isDone);
    }

    public boolean hasCurrentFlowIsFinish() {
        return this.flowSourceDirection == FlowSourceDirection.PASS && this.flowNode.isOverNode();
    }

    public boolean isDefaultBackRecord() {
        return this.flowSourceDirection == FlowSourceDirection.REJECT && !this.flowWork.hasBackRelation();
    }

    public boolean isPassRecord() {
        return this.flowSourceDirection == FlowSourceDirection.PASS;
    }

    public boolean isCustomBackRecord() {
        return this.flowSourceDirection == FlowSourceDirection.REJECT && this.flowWork.hasBackRelation();
    }

    public FlowSourceDirection getFlowSourceDirection() {
        return this.flowSourceDirection;
    }
}

