/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.content.FlowSession;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.pojo.FlowDetail;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowDetailService {
    private final FlowWorkRepository flowWorkRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowBindDataRepository flowBindDataRepository;
    private final FlowOperatorRepository flowOperatorRepository;
    private final FlowProcessRepository flowProcessRepository;

    public FlowDetail detail(long recordId, IFlowOperator currentOperator) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.setFlowRecordRead();
        flowRecordVerifyService.loadFlowWork();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        BindDataSnapshot snapshot = this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        List<FlowRecord> flowRecords = this.flowRecordRepository.findFlowRecordByProcessId(flowRecord.getProcessId()).stream().sorted((o1, o2) -> (int)(o2.getId() - o1.getId())).collect(Collectors.toList());
        ArrayList<IFlowOperator> operators = new ArrayList<IFlowOperator>();
        for (FlowRecord record : flowRecords) {
            operators.add(record.getCreateOperator());
            operators.add(record.getCurrentOperator());
            if (record.getInterferedOperator() == null) continue;
            operators.add(record.getInterferedOperator());
        }
        return new FlowDetail(flowRecord, snapshot, flowWork, flowRecords, operators, currentOperator != null && flowRecord.isTodo() && flowRecord.isOperator(currentOperator));
    }

    public FlowDetail detail(String workCode, IFlowOperator currentOperator) {
        if (currentOperator == null) {
            throw new IllegalArgumentException("current operator is null");
        }
        FlowWork flowWork = this.flowWorkRepository.getFlowWorkByCode(workCode);
        if (flowWork == null) {
            throw new IllegalArgumentException("flow work not found");
        }
        flowWork.enableValidate();
        FlowNode flowNode = flowWork.getStartNode();
        FlowSession flowSession = new FlowSession(null, flowWork, flowNode, currentOperator, currentOperator, null, null, new ArrayList<FlowRecord>());
        List<? extends IFlowOperator> operators = flowNode.loadFlowNodeOperator(flowSession, this.flowOperatorRepository);
        List operatorIds = operators.stream().map(IFlowOperator::getUserId).collect(Collectors.toList());
        if (!operatorIds.contains(currentOperator.getUserId())) {
            throw new IllegalArgumentException("current operator is not flow operator");
        }
        return new FlowDetail(flowWork, flowNode, operators, true);
    }

    public FlowDetailService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowBindDataRepository flowBindDataRepository, FlowOperatorRepository flowOperatorRepository, FlowProcessRepository flowProcessRepository) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowBindDataRepository = flowBindDataRepository;
        this.flowOperatorRepository = flowOperatorRepository;
        this.flowProcessRepository = flowProcessRepository;
    }
}

