/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.Collections;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowRecallService {
    private final FlowRecordRepository flowRecordRepository;
    private final FlowProcessRepository flowProcessRepository;

    public void recall(long recordId, IFlowOperator currentOperator) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyFlowRecordNotFinish();
        flowRecordVerifyService.verifyFlowRecordNotTodo();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        List<FlowRecord> childrenRecords = this.flowRecordRepository.findFlowRecordByPreId(recordId);
        if (flowRecord.isStartRecord() && flowRecord.isTodo()) {
            if (!childrenRecords.isEmpty()) {
                throw new IllegalArgumentException("flow record not recall");
            }
            this.flowRecordRepository.delete(Collections.singletonList(flowRecord));
        } else {
            if (childrenRecords.isEmpty()) {
                throw new IllegalArgumentException("flow record not submit");
            }
            boolean allUnDone = childrenRecords.stream().allMatch(item -> item.isUnRead() && item.isTodo());
            if (!allUnDone) {
                throw new IllegalArgumentException("flow record not recall");
            }
            flowRecord.recall();
            this.flowRecordRepository.update(flowRecord);
            this.flowRecordRepository.delete(childrenRecords);
        }
        EventPusher.push((IEvent)new FlowApprovalEvent(5, flowRecord, currentOperator, flowWork, null), (boolean)true);
    }

    public FlowRecallService(FlowRecordRepository flowRecordRepository, FlowProcessRepository flowProcessRepository) {
        this.flowRecordRepository = flowRecordRepository;
        this.flowProcessRepository = flowProcessRepository;
    }
}

